package com.intellij.javaee.artifact;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class JavaeeArtifactUtil {
  public static JavaeeArtifactUtil getInstance() {
    return ApplicationManager.getApplication().getService(JavaeeArtifactUtil.class);
  }

  public abstract Collection<? extends ArtifactType> getAllJavaeeArtifactTypes();

  public abstract <F extends JavaeeFacet> Collection<F> getFacetsIncludedInArtifact(@NotNull Project project, @NotNull Artifact artifact,
                                                                                    @Nullable FacetTypeId<F> facetType);

  @NotNull
  public abstract Collection<Artifact> getArtifactsContainingFacet(@NotNull JavaeeFacet facet, @Nullable ArtifactType artifactType);

  public abstract boolean isJavaeeApplication(@NotNull ArtifactType artifactType);

  public abstract boolean isEjbApplication(@NotNull ArtifactType artifactType);

  public abstract boolean isWebApplication(@NotNull ArtifactType artifactType);

  public abstract ArtifactType getExplodedEarArtifactType();

  public abstract ArtifactType getEarArtifactType();

  public abstract ArtifactType getExplodedEjbArtifactType();

  public abstract ArtifactType getEjbJarArtifactType();

  public abstract PackagingElement<?> createFacetResourcesElement(@NotNull JavaeeFacet facet);

  public abstract boolean isArchive(ArtifactType artifactType);

  @NotNull
  public abstract Collection<Artifact> getArtifactsContainingFacet(@NotNull JavaeeFacet facet, PackagingElementResolvingContext context, Collection<? extends ArtifactType> artifactTypes, boolean transitively);

  public abstract void addLibraryToAllArtifactsContainingFacet(@NotNull Library library, @NotNull JavaeeFacet facet);

  @Nullable
  public abstract String getRelativePath(@NotNull JavaeeFacet from, @NotNull JavaeeFacet to);
}
