/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.PsiTable;
import com.intellij.database.symbols.DasTableSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author gregsh
 */
public interface SqlTableDefinition extends SqlDefinition, PsiTable, DasTableSymbol {
  @Override
  @NotNull
  default DasTable getDasObject() {
    return this;
  }

  @Override
  SqlReferenceExpression getNameElement();

  @Nullable
  SqlExpression getQueryExpression();
}
