package com.intellij.psi.css.descriptor;

import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * User: zolotov
 * <p/>
 * Represent descriptor of css element that could have value descriptor.
 */
public interface CssValueOwnerDescriptor extends CssElementDescriptor {
  @NotNull
  CssValueDescriptor getValueDescriptor();

  @Nullable
  default String getFormalSyntax() {
    return null;
  }

  @Nullable
  default Map<String, String> getValuesDescription() {
    return null;
  }
}
