package com.intellij.psi.css.descriptor;

import com.intellij.lang.css.CssIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.Objects;

public final class CssPseudoSelectorDescriptorStub implements CssPseudoElementDescriptor, CssPseudoClassDescriptor, CssPseudoSelectorDescriptor {
  @NonNls private static final String EMPTY_STRING = "";
  private final String myName;
  private final boolean myElementSelector;
  private final boolean myHasArguments;

  public CssPseudoSelectorDescriptorStub(String name) {
    this(name, false, false);
  }

  public CssPseudoSelectorDescriptorStub(String name, boolean elementSelector) {
    this(name, elementSelector, false);
  }

  public CssPseudoSelectorDescriptorStub(String name, boolean elementSelector, boolean hasArguments) {
    myName = name;
    myElementSelector = elementSelector;
    myHasArguments = hasArguments;
  }

  @NotNull
  @Override
  public String getId() {
    return myName;
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return (myElementSelector ? "::" : ":") + getId();
  }

  @NotNull
  @Override
  public CssVersion getCssVersion() {
    return CssVersion.UNKNOWN;
  }

  @Override
  public BrowserVersion @NotNull [] getBrowsers() {
    return BrowserVersion.EMPTY_ARRAY;
  }

  @Override
  public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
    return true;
  }

  @NotNull
  @Override
  public String getDescription() {
    return EMPTY_STRING;
  }

  @Nullable
  @Override
  public String getDocumentationString(@Nullable PsiElement context) {
    return null;
  }

  @NotNull
  @Override
  public String getElementTypeName() {
    return CssBundle.message("css.pseudo.selector.label");
  }

  @Nullable
  @Override
  public String getSpecificationUrl() {
    return null;
  }

  @Override
  public CssContextType @NotNull [] getAllowedContextTypes() {
    return CssContextType.EMPTY_ARRAY;
  }

  @Override
  public @NotNull Icon getIcon() {
    return myElementSelector ? CssIcons.PseudoElement : CssIcons.PseudoClass;
  }

  @Override
  public boolean hasArguments() {
    return myHasArguments;
  }

  @Override
  public int getColonPrefixLength() {
    return myElementSelector ? 2 : 1;
  }

  @Override
  public boolean isElementRequired() {
    return false;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof CssPseudoSelectorDescriptorStub)) return false;

    CssPseudoSelectorDescriptorStub stub = (CssPseudoSelectorDescriptorStub)o;
    return Objects.equals(myName, stub.myName)
      && myElementSelector == stub.myElementSelector
      && myHasArguments == stub.myHasArguments;
  }

  @Override
  public int hashCode() {
    return myName != null ? myName.hashCode() : 0;
  }
}
