package com.intellij.psi.css.descriptor;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public class CssFunctionDescriptorStub implements CssFunctionDescriptor {
  @NonNls private static final String EMPTY_STRING = "";
  private final String myName;
  @NotNull private final CssValueDescriptor myValueDescriptor;
  private final CssTermType myReturnType;
  @Nullable private final PsiElement myElement;

  public CssFunctionDescriptorStub(@NotNull String name, @NotNull CssValueDescriptor valueDescriptor) {
    this(name, valueDescriptor, CssTermType.UNKNOWN);
  }

  public CssFunctionDescriptorStub(@NotNull String name,
                                   @NotNull CssValueDescriptor valueDescriptor,
                                   CssTermType returnType) {
    this(name, valueDescriptor, returnType, null);
  }

  public CssFunctionDescriptorStub(@NotNull String name,
                                   @NotNull CssValueDescriptor valueDescriptor,
                                   CssTermType returnType, 
                                   @Nullable PsiElement navigableElement) {
    myName = name;
    myValueDescriptor = valueDescriptor;
    myReturnType = returnType;
    myElement = navigableElement;
  }

  @NotNull
  @Override
  public String getId() {
    return myName;
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return getId();
  }

  @NotNull
  @Override
  public CssVersion getCssVersion() {
    return CssVersion.UNKNOWN;
  }

  @Override
  public BrowserVersion @NotNull [] getBrowsers() {
    return BrowserVersion.EMPTY_ARRAY;
  }

  @NotNull
  @Override
  public CssValueDescriptor getValueDescriptor() {
    return myValueDescriptor;
  }

  @Override
  public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
    return true;
  }

  @NotNull
  @Override
  public String getDescription() {
    return EMPTY_STRING;
  }

  @Nullable
  @Override
  public String getDocumentationString(@Nullable PsiElement context) {
    return null;
  }

  @NotNull
  @Override
  public String getElementTypeName() {
    return CssBundle.message("css.function");
  }

  @Nullable
  @Override
  public String getSpecificationUrl() {
    return null;
  }

  @Override
  public CssContextType @NotNull [] getAllowedContextTypes() {
    return CssContextType.EMPTY_ARRAY;
  }

  @NotNull
  @Override
  public CssTermType getType() {
    return myReturnType;
  }

  @Nullable
  @Override
  public Icon getIcon() {
    return AllIcons.Nodes.Lambda;
  }

  @Nullable
  @Override
  public PsiElement getElement() {
    return myElement;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof CssFunctionDescriptorStub)) return false;

    CssFunctionDescriptorStub stub = (CssFunctionDescriptorStub)o;

    if (!myName.equals(stub.myName)) return false;

    return true;
  }

  @Override
  public int hashCode() {
    return myName.hashCode();
  }
}
