package com.intellij.psi.css;

import org.jetbrains.annotations.NotNull;

public final class SelectorSpecificity implements Comparable<SelectorSpecificity> {
  public static final SelectorSpecificity UNLIMITED = new SelectorSpecificity(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
  public static final SelectorSpecificity EMPTY = new SelectorSpecificity(0, 0, 0);

  private final int myIdSelectorsNumber;
  private final int myClassAndAttributeSelectorsNumber;
  private final int myTypeSelectorsAndPseudoElementsNumber;

  public SelectorSpecificity(int idSelectorsNumber, int classAndAttributeSelectorsNumber, int typeSelectorsAndPseudoElementsNumber) {
    myIdSelectorsNumber = idSelectorsNumber;
    myClassAndAttributeSelectorsNumber = classAndAttributeSelectorsNumber;
    myTypeSelectorsAndPseudoElementsNumber = typeSelectorsAndPseudoElementsNumber;
  }

  public int getIdSelectorsNumber() {
    return myIdSelectorsNumber;
  }

  public int getClassAndAttributeSelectorsNumber() {
    return myClassAndAttributeSelectorsNumber;
  }

  public int getTypeSelectorsAndPseudoElementsNumber() {
    return myTypeSelectorsAndPseudoElementsNumber;
  }

  @Override
  public int compareTo(@NotNull SelectorSpecificity other) {
    int d = myIdSelectorsNumber - other.myIdSelectorsNumber;
    if (d != 0) {
      return d;
    }
    d = myClassAndAttributeSelectorsNumber - other.myClassAndAttributeSelectorsNumber;
    if (d != 0) {
      return d;
    }
    return myTypeSelectorsAndPseudoElementsNumber - other.myTypeSelectorsAndPseudoElementsNumber;
  }

  public @NotNull String getPresentableText() {
    return "(" + myIdSelectorsNumber + ", " + myClassAndAttributeSelectorsNumber + ", " + myTypeSelectorsAndPseudoElementsNumber + ")";
  }

  @Override
  public String toString() {
    return getPresentableText();
  }
}
