/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.descriptor.CssMediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public interface CssImport extends CssOneLineStatement, CssImportLikeElement {
  CssImport[] EMPTY_ARRAY = new CssImport[0];

  String @NotNull [] getUriStrings();

  boolean isScreen();

  PsiElement @NotNull [] getUriElements();

  PsiFile @NotNull [] resolve();

  @Nullable
  CssMediumList getMediumList();

  @NotNull
  Set<CssMediaType> getMediaTypes();
  
  @Nullable
  CssAtRule getSupports();
}
