// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.model.SpringConditional;

/**
 * All condition JAM elements must implement this interface to be evaluated.
 * <p>
 * Registration via {@link #CONDITIONAL_JAM_ELEMENT_KEY} subKey is required.
 */
public interface ConditionalOnJamElement extends SpringConditional {

  SemKey<ConditionalOnJamElement> CONDITIONAL_JAM_ELEMENT_KEY =
    SpringConditional.SPRING_CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnJamElement");


  ConditionOutcome matches(ConditionalOnEvaluationContext context);

  interface NonStrict extends ConditionalOnJamElement {

    @Override
    default ConditionOutcome matches(ConditionalOnEvaluationContext context) {
      return ConditionOutcome.noMatch("Strict Mode (cannot evaluate)");
    }
  }
}
