// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Nullable;

/**
 * Registers {@link ConditionalContributor} implementation via FQN of actual Condition.
 */
final class ConditionalContributorEP extends CustomLoadingExtensionPointBean<ConditionalContributor> implements KeyedLazyInstance<ConditionalContributor> {
  /**
   * FQN of library condition class.
   */
  @Attribute("condition")
  public String condition;

  /**
   * IDE implementation of condition class.
   */
  @Attribute("implementation")
  public String implementation;

  @Nullable
  @Override
  protected String getImplementationClassName() {
    return implementation;
  }

  @Override
  public String getKey() {
    return condition;
  }
}
