// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NotNull;

/**
 * Pluggable mechanism to evaluate actual Conditional behavior at design time.
 *
 * @see ConditionalContributorEP
 */
public abstract class ConditionalContributor {

  static final ExtensionPointName<ConditionalContributor> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.boot.modelConditionalContributor");

  public abstract ConditionOutcome matches(ConditionalOnEvaluationContext context);

  /**
   * Checks whether given config key is set.
   *
   * @param context   Context.
   * @param configKey Configuration key to find.
   * @return {@code true} if configuration key was found.
   */
  protected boolean hasConfigKey(ConditionalOnEvaluationContext context, @NotNull String configKey) {
    return !context.processConfigurationValues(results -> results.isEmpty(), true, configKey);
  }
}
