// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.util.text.StringUtil;

public final class ConditionMessage {
  private final String myText;

  ConditionMessage(String text) {
    myText = text;
  }

  public String getText() {
    return myText;
  }

  public static ConditionMessage found(String thing, String... objects) {
    return generic("Found", thing, objects);
  }

  public static ConditionMessage didNotFind(String thing, String... objects) {
    return generic("Did not find", thing, objects);
  }

  public static ConditionMessage foundClass(String fqn) {
    return found("required class", fqn);
  }

  public static ConditionMessage didNotFindClass(String... fqns) {
    return didNotFind("required class", fqns);
  }

  public static ConditionMessage didNotFindUnwantedClass(String... fqns) {
    return didNotFind("unwanted class", fqns);
  }

  public static ConditionMessage didNotFindConfigKey(String... configKeys) {
    return didNotFind("property", configKeys);
  }

  public static ConditionMessage foundConfigKey(String configKey) {
    return found("property", configKey);
  }

  public static ConditionMessage foundConfigKeyWithValue(String configKey, String value) {
    return found("property", configKey + "=" + value);
  }

  public static ConditionMessage generic(String prefix, String thing, String... objects) {
    if (objects.length == 0) {
      return new ConditionMessage(prefix + " " + thing);
    }

    return new ConditionMessage(prefix + " " + StringUtil.pluralize(thing, objects.length) +
                                " " + StringUtil.join(objects, s -> "'" + s + "'", ", "));
  }
}
