// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public interface SpringBootConfigurationFileService {
  static SpringBootConfigurationFileService getInstance() {
    return ApplicationManager.getApplication().getService(SpringBootConfigurationFileService.class);
  }

  /**
   * @return {@code true} if the given file is a configuration file and it belongs to Spring Boot file set, otherwise {@code false}.
   */
  boolean isApplicationConfigurationFile(@NotNull PsiFile file);

  /**
   * @return icon provided by corresponding {@link SpringBootModelConfigFileNameContributor} or {@code null},
   * if the given file is not a configuration file or it does not belong to Spring Boot file set.
   */
  @Nullable
  Icon getApplicationConfigurationFileIcon(@NotNull PsiFile file);
}
