// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.metadata;

import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public abstract class SpringBootApplicationMetaConfigKeyManager extends MetaConfigKeyManager {
  /**
   * Set the flag to {@code true} for Psi file in order to mark its content as acceptable by config key documentation provider.
   */
  public static final Key<Boolean> ELEMENT_IN_EXTERNAL_CONTEXT = Key.create("ElementInExternalContext");

  public static SpringBootApplicationMetaConfigKeyManager getInstance() {
    return ApplicationManager.getApplication().getService(SpringBootApplicationMetaConfigKeyManager.class);
  }

  /**
   * @deprecated Kept with narrower return type for backward compatibility.
   */
  @Deprecated
  @Override
  public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable PsiElement psiElement) {
    //noinspection unchecked
    return (List<SpringBootApplicationMetaConfigKey>)super.getAllMetaConfigKeys(psiElement);
  }
}
