package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.oss.server.JavaeeServerHelper;

public class TomcatServerHelper extends JavaeeServerHelper {

  private final TomcatIntegration myIntegration;
  private final boolean myTomEEOnly;

  public TomcatServerHelper(TomcatIntegration integration, boolean tomEEOnly) {
    super(integration);
    myIntegration = integration;
    myTomEEOnly = tomEEOnly;
  }

  @Override
  public ApplicationServerPersistentData createPersistentDataEmptyInstance() {
    return new TomcatPersistentData();
  }

  @Override
  public ApplicationServerPersistentDataEditor createConfigurable() {
    return new TomcatPersistentDataEditor(myIntegration, myTomEEOnly);
  }
}
