package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import org.jetbrains.annotations.NotNull;

public final class TomcatConfiguration extends TomcatConfigurationBase {
  public static TomcatConfiguration getInstance() {
    return ConfigurationTypeUtil.findConfigurationType(TomcatConfiguration.class);
  }

  public TomcatConfiguration() {
    super("#com.intellij.j2ee.web.tomcat.TomcatRunConfigurationFactory");
  }

  @NotNull
  @Override
  public JavaeeIntegration getIntegration() {
    return TomcatIntegration.getInstance();
  }

  @NotNull
  @Override
  public String getTag() {
    return "tomcat";
  }

  @Override
  public String getHelpTopic() {
    return "reference.dialogs.rundebug.j2ee.web.tomcat.TomcatRunConfiguration";
  }

  @Override
  public boolean isEditableInDumbMode(boolean isLocal) {
    return true;
  }
}