package org.jetbrains.idea.tomcat.profiler;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.profiler.ultimate.JavaProfilerStarterExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;

final class TomcatLocalProfilerStarterExtension extends JavaProfilerStarterExtension {
  @Override
  public boolean canRun(@NotNull RunProfile profile) {
    return profile instanceof CommonStrategy && ((CommonStrategy)profile).getServerModel() instanceof TomcatLocalModel;
  }
}
