package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsSafe;
import org.jdom.Element;

public abstract class TomcatContextItem {

  private final Element myElement;
  @NlsSafe private final String myPath;

  public TomcatContextItem(Element element, String path) {
    myElement = element;
    myPath = path;
  }

  public Element getElement() {
    return myElement;
  }

  @NlsSafe
  public String getPath() {
    return myPath;
  }

  public abstract void remove() throws ExecutionException;
}
