/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.roles;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.psi.PsiClass;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public abstract class PersistenceRoleHolder {
  public static PersistenceRoleHolder getInstance(Project project) {
    return project.getService(PersistenceRoleHolder.class);
  }

  public abstract boolean processAllRoles(@NotNull PsiClass aClass, @NotNull Processor<? super PersistenceClassRole> processor);

  public abstract boolean processModuleRoles(@NotNull Module module,
                                             @NotNull PsiClass aClass,
                                             @NotNull Processor<? super PersistenceClassRole> processor);

  public abstract boolean processXmlRoles(@NotNull PsiClass aClass, @NotNull Processor<? super PersistenceClassRole> processor);

  public abstract boolean processAllRoles(@NotNull Processor<? super PersistenceClassRole> processor);

  public abstract boolean processMergedQueries(final PersistenceFacet facet, @NotNull Processor<? super PersistenceQuery> processor);
}
