/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.model.manipulators;

import com.intellij.openapi.module.Module;
import com.intellij.persistence.model.*;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

/**
 * @author Gregory.Shrago
 */
public interface PersistenceMappingsManipulator<T extends PersistenceMappings> extends PersistenceManipulator<T> {
  PersistentEntity addEntity(@NotNull Module module,
                             final PsiDirectory directory,
                             final PersistencePackage unit,
                             final String shortClassName,
                             final String entityName) throws IncorrectOperationException;
  PersistentSuperclass addSuperclass(final PsiDirectory directory, final PersistencePackage unit, final String shortClassName) throws IncorrectOperationException;
  PersistentEmbeddable addEmbeddable(final PsiDirectory directory, final PersistencePackage unit, final String shortClassName) throws IncorrectOperationException;
}
