package com.intellij.persistence.model;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.Nullable;

public class PersistentObjectNameProvider extends PresentationProvider {
  @Nullable
  @Override
  public String getName(Object o) {
    return getPresentableName(o);
  }

  public static @NlsSafe String getPresentableName(Object o) {
    if (o instanceof PersistentEntity) {
      return ((PersistentEntity)o).getName().getValue();
    }
    if (o instanceof PersistentObject) {
      return PsiNameHelper.getShortClassName(StringUtil.notNullize(((PersistentObject)o).getClazz().getStringValue()));
    }
    return null;
  }
}
