/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.model;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.persistence.model.helpers.PersistentAttributeModelHelper;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NameValue;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
@DeleteHandler(handlerClass = JpaPersistenceAttributeDeleteHandler.class)
public interface PersistentAttribute extends CommonModelElement {

  PersistentAttribute[] EMPTY_ARRAY = new PersistentAttribute[0];

  @NameValue
  GenericValue<String> getName();

  @Nullable
  PsiMember getPsiMember();

  @Nullable
  PersistentObject getPersistentObject();

  @Nullable
  PsiType getPsiType();

  PersistentAttributeModelHelper getAttributeModelHelper();
}
