/*
 * Copyright (c) 2000-2006 JetBrains s.r.o. All Rights Reserved.
 */

package com.intellij.persistence.model;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;

import java.util.Collection;

public class JpaPersistenceListenerDeleteHandler extends JamDeleteHandler {
  @Override
  public void addPsiElements(final CommonModelElement element, final Collection<? super PsiElement> result) {
     if (element instanceof PersistenceListener) {
      ContainerUtil.addIfNotNull(result, ((PersistenceListener)element).getClazz().getValue());
    }
  }
}
