/*
 * Copyright (c) 2000-2006 JetBrains s.r.o. All Rights Reserved.
 */

package com.intellij.persistence.model;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;

import java.util.Collection;

public class JpaPersistenceAttributeDeleteHandler extends JamDeleteHandler {

  @Override
  public void addPsiElements(final CommonModelElement element, final Collection<? super PsiElement> result) {
    if (element instanceof PersistentAttribute) {
      result.addAll(PersistenceCommonUtil.getAttributePsiMembers((PersistentAttribute)element));
    }
  }
}
