/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.facet;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

/**
 * @author Gregory.Shrago
 */
public interface PersistenceFacet extends UserDataHolderEx {
                 
  Module getModule();

  ModificationTracker getModificationTracker();

  ConfigFile[] getDescriptors();

  ConfigFileContainer getDescriptorsContainer();

  @NotNull
  List<? extends PersistencePackage> getPersistenceUnits();

  List<PersistencePackage> getExplicitPersistenceUnits();

  @Nullable
  PersistenceMappings getAnnotationEntityMappings();

  @NotNull
  PersistenceMappings getEntityMappings(@NotNull final PersistencePackage unit);

  @Nullable
  PersistenceMappings getAnnotationEntityMappings(@NotNull final PersistencePackage unit);

  @NotNull
  List<? extends PersistenceMappings> getDefaultEntityMappings(@NotNull final PersistencePackage unit);

  @NotNull
  Class<? extends PersistencePackage> getPersistenceUnitClass();

  @NotNull
  Map<ConfigFileMetaData,Class<? extends PersistenceMappings>> getSupportedDomMappingFormats();

  String getDataSourceId(@NotNull final PersistencePackagePointer unit);

  String getDataSourceId(@NotNull final PersistencePackage unit);

  void setDataSourceId(@NotNull final PersistencePackage unit, final String dataSourceId);

  @Nullable
  Language getQlLanguage();

  @NotNull
  ModelValidator getModelValidator(@Nullable final PersistencePackage unit);

  Class @NotNull [] getInspectionToolClasses();

  @NotNull
  PersistencePackageDefaults getPersistenceUnitDefaults(@NotNull final PersistencePackage unit);

  String getNamingStrategy(@NotNull PersistencePackage unit);

  void setNamingStrategy(@NotNull PersistencePackage unit, String namingStrategy);
}
