/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.diagram;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiType;
import com.intellij.util.PairProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public interface PersistenceDiagramSupport<Unit, Entity, Attribute> {

  ModificationTracker getModificationTracker(final Unit unit);

  void startDataModelUpdate(final Unit unit);

  void finishDataModelUpdate();

  String getUniqueId(final Entity entity);

  void processEntities(final PairProcessor<? super Entity, String> processor, final boolean superclasses, final boolean embeddables);

  void processSuper(final Entity sourceEntity, final PairProcessor<? super Entity, String> processor);

  void processRelated(final Entity sourceEntity, final PairProcessor<? super Attribute, String> processor);

  void processEmbedded(final Entity sourceEntity, final PairProcessor<? super Attribute, String> processor);

  void processAttributes(final Entity sourceEntity, final PairProcessor<? super Attribute, String> processor);

  @Nullable
  Entity getAttributeTarget(final Attribute attribute);

  @Nullable
  Attribute getInverseSideAttribute(final Attribute attribute);

  @Nullable
  String getAttributeName(final Attribute attribute);

  @Nullable
  PsiType getAttributePsiType(final Attribute attribute);

  @NotNull
  String getEntityTypeName(final Entity entity);

  @NotNull
  String getAttributeTypeName(final Attribute attribute);

  boolean isIdAttribute(final Attribute attribute);

  @NotNull
  String getAttributeMultiplicityLabel(final Attribute first, final Attribute second, boolean isSource);

  @Nullable
  Icon getEntityIcon(final Entity entity);

  @Nullable
  Icon getAttributeIcon(final Attribute attribute, final boolean forceId);

  @NotNull
  DataProvider createDataProvider(final PersistenceDiagram<Unit, Entity, Attribute> diagram);

  boolean processEditNode(final PersistenceDiagram<Unit, Entity, Attribute> diagram, final Entity entity);

  boolean processEditEdge(final PersistenceDiagram<Unit, Entity, Attribute> diagram);

  void processCreateEdge(final PersistenceDiagram<Unit, Entity, Attribute> diagram, final Entity sourceEntity, final Entity targetEntity);

  void customizeGraphView(final Graph2DView view, final EditMode editMode);
}
