/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.maven;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.DisposeAwareRunnable;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class ImportMavenProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%importMavenProject";

    public ImportMavenProjectCommand(@NotNull String text, int line) {
        if (text == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        @NotNull Project project = context.getProject();
        this.runWhenMavenImportAndIndexingFinished(context, () -> ImportMavenProjectCommand.lambda$_execute$0((ActionCallback)actionCallback), project);
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private void runWhenMavenImportAndIndexingFinished(@NotNull PlaybackContext context, @NotNull Runnable runnable, @NotNull Project project) {
        if (context == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(5);
        }
        ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)project);
        ExternalSystemProjectTrackerSettings.AutoReloadType currentAutoReloadType = projectTrackerSettings.getAutoReloadType();
        projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        context.message("Waiting for fully open and initialized maven project", this.getLine());
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> MavenUtil.runWhenInitialized((Project)project, () -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.waitForCurrentMavenImportActivities(context, project).thenAsync(promise -> {
            context.message("Import of the project has been started", this.getLine());
            MavenProjectsManager mavenManager = MavenProjectsManager.getInstance((Project)project);
            if (!mavenManager.isMavenizedProject()) {
                mavenManager.addManagedFiles(mavenManager.collectAllAvailablePomFiles());
            }
            return mavenManager.forceUpdateProjects();
        }).thenAsync(promise -> this.waitForCurrentMavenImportActivities(context, project)).onProcessed(promise -> {
            context.message("Import of the maven project has been finished", this.getLine());
            projectTrackerSettings.setAutoReloadType(currentAutoReloadType);
            DumbService.getInstance((Project)project).runWhenSmart(DisposeAwareRunnable.create((Runnable)runnable, (Project)project));
        }))));
    }

    private Promise<?> waitForCurrentMavenImportActivities(@NotNull PlaybackContext context, @NotNull Project project) {
        if (context == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(7);
        }
        context.message("Waiting for current maven import activities", this.getLine());
        return MavenProjectsManager.getInstance((Project)project).waitForImportCompletion().onProcessed(o -> context.message("Maven import activities completed", this.getLine()));
    }

    private static /* synthetic */ void lambda$_execute$0(ActionCallback actionCallback) {
        actionCallback.setDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/maven/ImportMavenProjectCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/maven/ImportMavenProjectCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWhenMavenImportAndIndexingFinished";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitForCurrentMavenImportActivities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

