/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidDbUtil {
    public static final Object DB_SYNC_LOCK = new Object();
    private static final String DEVICE_ID_EMULATOR_PREFIX = "EMULATOR_";
    private static final String DEVICE_ID_SERIAL_NUMBER_PREFIX = "SERIAL_NUMBER_";

    private AndroidDbUtil() {
    }

    @Nullable
    public static AndroidDbConnectionInfo checkDataSource(@NotNull AndroidDataSource dataSource, @NotNull AndroidDebugBridge debugBridge, @NotNull AndroidDbErrorReporter errorReporter) {
        if (dataSource == null) {
            AndroidDbUtil.$$$reportNull$$$0(0);
        }
        if (debugBridge == null) {
            AndroidDbUtil.$$$reportNull$$$0(1);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(2);
        }
        AndroidDataSource.State state = dataSource.getState();
        String deviceId = state.deviceId;
        if (deviceId == null) {
            errorReporter.reportError("device is not specified");
            return null;
        }
        IDevice device = AndroidDbUtil.getDeviceById(debugBridge, deviceId);
        if (device == null) {
            errorReporter.reportError("device '" + AndroidDbUtil.getPresentableNameFromDeviceId(deviceId) + "' is not connected");
            return null;
        }
        if (!device.isOnline()) {
            errorReporter.reportError("the device is not online");
            return null;
        }
        String packageName = dataSource.getState().packageName;
        if (packageName == null || packageName.length() == 0) {
            errorReporter.reportError("package name is not specified");
            return null;
        }
        String dbName = dataSource.getState().databaseName;
        if (dbName == null || dbName.length() == 0) {
            errorReporter.reportError("database name is not specified");
            return null;
        }
        return new AndroidDbConnectionInfo(device, packageName, dbName, dataSource.getState().external);
    }

    @Nullable
    private static IDevice getDeviceById(@NotNull AndroidDebugBridge debugBridge, @NotNull String deviceId) {
        if (debugBridge == null) {
            AndroidDbUtil.$$$reportNull$$$0(3);
        }
        if (deviceId == null) {
            AndroidDbUtil.$$$reportNull$$$0(4);
        }
        for (IDevice device : debugBridge.getDevices()) {
            if (!deviceId.equals(AndroidDbUtil.getDeviceId(device))) continue;
            return device;
        }
        return null;
    }

    @Nullable
    public static String getDeviceId(@NotNull IDevice device) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(5);
        }
        if (device.isEmulator()) {
            String avdName = device.getAvdName();
            return avdName == null ? null : DEVICE_ID_EMULATOR_PREFIX + AndroidDbUtil.replaceByDirAllowedName(avdName);
        }
        String serialNumber = device.getSerialNumber();
        if (serialNumber != null && serialNumber.length() > 0) {
            return DEVICE_ID_SERIAL_NUMBER_PREFIX + AndroidDbUtil.replaceByDirAllowedName(serialNumber);
        }
        String manufacturer = DevicePropertyUtil.getManufacturer((IDevice)device, (String)"");
        String model = DevicePropertyUtil.getModel((IDevice)device, (String)"");
        if (manufacturer.length() > 0 || model.length() > 0) {
            return AndroidDbUtil.replaceByDirAllowedName(manufacturer + "_" + model);
        }
        return null;
    }

    @NotNull
    public static String getPresentableNameFromDeviceId(@NotNull String deviceId) {
        if (deviceId == null) {
            AndroidDbUtil.$$$reportNull$$$0(6);
        }
        if (deviceId.startsWith(DEVICE_ID_EMULATOR_PREFIX)) {
            String string = "emulator: " + deviceId.substring(DEVICE_ID_EMULATOR_PREFIX.length());
            if (string == null) {
                AndroidDbUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (deviceId.startsWith(DEVICE_ID_SERIAL_NUMBER_PREFIX)) {
            String string = "serial: " + deviceId.substring(DEVICE_ID_SERIAL_NUMBER_PREFIX.length());
            if (string == null) {
                AndroidDbUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = deviceId;
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String replaceByDirAllowedName(@NotNull String s) {
        if (s == null) {
            AndroidDbUtil.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            builder.append(c);
        }
        String string = builder.toString();
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getInternalDatabasesRemoteDirPath(@NotNull String packageName) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(12);
        }
        String string = "/data/data/" + packageName + "/databases";
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getExternalDatabasesRemoteDirPath(@NotNull String packageName) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(14);
        }
        String string = "$EXTERNAL_STORAGE/Android/data/" + packageName;
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getDatabaseRemoteFilePath(@NotNull String packageName, @NotNull String dbName, boolean external) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(16);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(17);
        }
        dbName = StringUtil.trimStart((String)dbName, (String)"/");
        String string = AndroidDbUtil.getDatabaseRemoteDirPath(packageName, external) + "/" + dbName;
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getDatabaseRemoteDirPath(@NotNull String packageName, boolean external) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(19);
        }
        if (external) {
            return AndroidDbUtil.getExternalDatabasesRemoteDirPath(packageName);
        }
        return AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName);
    }

    @NonNls
    public static String getFingerprint(DeviceFileEntry file) {
        return file.getLastModifiedDate().getText() + ":" + file.getSize();
    }

    @NotNull
    static FileTransferProgress wrapAsFileTransferProgress(final @NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(20);
        }
        return new FileTransferProgress(){

            public void progress(long currentBytes, long totalBytes) {
                progressIndicator.setFraction((double)currentBytes / (double)totalBytes);
            }

            public boolean isCancelled() {
                return progressIndicator.isCanceled();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugBridge";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDbUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDbUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameFromDeviceId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceByDirAllowedName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalDatabasesRemoteDirPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalDatabasesRemoteDirPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseRemoteFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDataSource";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameFromDeviceId";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceByDirAllowedName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInternalDatabasesRemoteDirPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDatabasesRemoteDirPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseRemoteFilePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseRemoteDirPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrapAsFileTransferProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

