/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.debugger.wip.WipConsoleMessageTask$WhenMappings;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.console.ConsoleMessageValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleMessageTask;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;", "vm", "Lorg/jetbrains/wip/WipVm;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "xmlView", "intellij.javascript.chrome.connector"})
public final class WipConsoleMessageTask
implements ConsoleMessage {
    private final ConsoleMessageValue message;
    private final WipVm vm;
    private final RequestInfo request;

    /*
     * Unable to fully structure code
     */
    public void print(@NotNull ConsoleMessageBuilder printer) {
        block30: {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$0[this.message.level().ordinal()]) {
                case 1: {
                    v0 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                    break;
                }
                case 2: {
                    v0 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                    break;
                }
                case 3: {
                    v0 = ConsoleViewContentType.LOG_INFO_OUTPUT;
                    break;
                }
                case 4: {
                    v0 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                    break;
                }
                default: {
                    v0 = contentType = ConsoleViewContentType.NORMAL_OUTPUT;
                }
            }
            if (this.message.getType() == ConsoleMessageValue.Type.END_GROUP) {
                printer.groupEnd();
                return;
            }
            v1 = contentType;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"contentType");
            printer.startMessage(v1, this.message.source().toString());
            url = this.message.getUrl();
            line = this.message.getLine();
            column = this.message.getColumn();
            v2 = this.message.getStack();
            stackTrace = v2 != null ? v2.callFrames() : null;
            block6 : switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$2[this.message.source().ordinal()]) {
                case 1: {
                    if (this.request == null) {
                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, null, (int)6, null);
                        v3 = this.message.getUrl();
                        Intrinsics.checkNotNull((Object)v3);
                        ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)v3, (int)-1, (int)-1, null, (boolean)false, null, (int)32, null);
                        break;
                    }
                    if (this.request.getInitiator() != null) {
                        v4 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)v4);
                        v5 = v4.getStack();
                        stackTrace = v5 != null ? v5.callFrames() : null;
                        v6 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)v6);
                        if (!StringUtil.isEmpty((String)v6.getUrl())) {
                            v7 = this.request.getInitiator();
                            Intrinsics.checkNotNull((Object)v7);
                            url = v7.getUrl();
                            v8 = this.request.getInitiator();
                            Intrinsics.checkNotNull((Object)v8);
                            line = (int)v8.getLineNumber();
                            column = -1;
                        }
                    }
                    if (this.message.level() == ConsoleMessageValue.Level.ERROR) {
                        this.printFailedNetworkRequestMessage(printer);
                        break;
                    }
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, null, (int)6, null);
                    break;
                }
                default: {
                    v9 = this.message.getType();
                    if (v9 != null) {
                        switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$1[v9.ordinal()]) {
                            case 1: 
                            case 2: {
                                v10 = this.message.getParameters();
                                Intrinsics.checkNotNull(v10);
                                remoteObjectValue = v10.get(0);
                                if (remoteObjectValue.type() == RemoteObjectValue.Type.STRING) {
                                    v11 = remoteObjectValue.value();
                                    if (v11 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    v12 = (String)v11;
                                } else {
                                    v12 = remoteObjectValue.getDescription();
                                    if (v12 == null) {
                                        v12 = "console.group()";
                                    }
                                }
                                groupName = v12;
                                printer.groupStart(groupName, false);
                                break block6;
                            }
                            case 3: 
                            case 4: {
                                this.printParameters(printer, contentType, false, this.message.getType() != ConsoleMessageValue.Type.DIR);
                                break block6;
                            }
                            case 5: {
                                printer.clear();
                                v13 = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Console was cleared", (ConsoleViewContentType)v13, null, (int)4, null);
                                break block6;
                            }
                        }
                    }
                    if (this.message.getType() == ConsoleMessageValue.Type.ASSERT) {
                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Assertion failed:", (ConsoleViewContentType)contentType, null, (int)4, null);
                        WipConsoleMessageTask.printParameters$default(this, printer, contentType, true, false, 8, null);
                        break;
                    }
                    if (!UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
                        WipConsoleMessageTask.printParameters$default(this, printer, contentType, false, false, 8, null);
                        break;
                    }
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), (ConsoleViewContentType)contentType, null, (int)4, null);
                }
            }
            v14 = isFromNetwork = this.message.source() == ConsoleMessageValue.Source.NETWORK;
            if (isFromNetwork && this.request == null) break block30;
            v15 = stackTrace;
            v16 = callFrame = v15 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v15) : null;
            if (callFrame == null) ** GOTO lbl-1000
            var9_11 = callFrame.url();
            var10_12 = false;
            var11_13 = false;
            if (!(var9_11 == null || var9_11.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)(callFrame.getLineNumber() - 1), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)(isFromNetwork == false), null, (int)32, null);
            } else lbl-1000:
            // 2 sources

            {
                var9_11 = url;
                var10_12 = false;
                var11_13 = false;
                if (!(var9_11 == null || var9_11.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    v17 = url;
                    Intrinsics.checkNotNull((Object)v17);
                    ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)v17, (int)(line - 1), (int)column, null, (boolean)(isFromNetwork == false), null, (int)32, null);
                }
            }
        }
        v18 = willPrintStackTrace = ContainerUtil.isEmpty((Collection)stackTrace) == false && (this.message.source() == ConsoleMessageValue.Source.NETWORK || this.message.level() == ConsoleMessageValue.Level.ERROR || this.message.getType() == ConsoleMessageValue.Type.TRACE);
        if (willPrintStackTrace) {
            printer.printStackTrace(contentType, this.message.getStack());
        }
        printer.endMessage();
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        Intrinsics.checkNotNull((Object)requestInfo);
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            Intrinsics.checkNotNull((Object)string);
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                Intrinsics.checkNotNull((Object)string);
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, boolean isNotFirst, boolean xmlView) {
        boolean isNotFirst2 = isNotFirst;
        if (UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
            return;
        }
        List<RemoteObjectValue> list = this.message.getParameters();
        Intrinsics.checkNotNull(list);
        for (RemoteObjectValue objectValue : list) {
            if (isNotFirst2) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)" ", (ConsoleViewContentType)contentType, null, (int)4, null);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                EvaluateContext evaluateContext2 = this.vm.getEvaluateContext();
                if (evaluateContext2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                }
                ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
                if (valueManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                }
                WipValueManager valueManager2 = (WipValueManager)valueManager;
                Value value = valueManager2.createValue(objectValue);
                Intrinsics.checkNotNull((Object)value);
                printer.printAndStoreValueToInspect(value, null, contentType, xmlView);
                continue;
            }
            if (objectValue.value() != null) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)String.valueOf(objectValue.value()), (ConsoleViewContentType)contentType, null, (int)4, null);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            Intrinsics.checkNotNull((Object)string);
            ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)string, (ConsoleViewContentType)contentType, null, (int)4, null);
        }
    }

    static /* synthetic */ void printParameters$default(WipConsoleMessageTask wipConsoleMessageTask, ConsoleMessageBuilder consoleMessageBuilder, ConsoleViewContentType consoleViewContentType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        wipConsoleMessageTask.printParameters(consoleMessageBuilder, consoleViewContentType, bl, bl2);
    }

    public WipConsoleMessageTask(@NotNull ConsoleMessageValue message, @NotNull WipVm vm, @Nullable RequestInfo request) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.message = message;
        this.vm = vm;
        this.request = request;
    }
}

