/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.utils;

import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.utils.PwaHashUtils;
import com.intellij.openapi.projectRoots.Sdk;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/java/utils/PwaJdkHashUtils;", "", "()V", "NO_SDK_HASH", "", "SDK_NAME_HASH", "computeHashesSymbolList", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "projectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdkNameHash", "intellij.java.pwa"})
public final class PwaJdkHashUtils {
    private static final int NO_SDK_HASH;
    private static final int SDK_NAME_HASH;
    @NotNull
    public static final PwaJdkHashUtils INSTANCE;

    @NotNull
    public final SymbolHashesList computeHashesSymbolList(@Nullable Sdk projectSdk) {
        int hash = projectSdk != null ? PwaHashUtils.combineHash((int)PwaHashUtils.hashText((String)projectSdk.getHomePath()), (int)PwaHashUtils.hashText((String)projectSdk.getName())) : NO_SDK_HASH;
        IntArrayList intArrayList = IntArrayList.of((int[])new int[]{SDK_NAME_HASH});
        Intrinsics.checkNotNullExpressionValue((Object)intArrayList, (String)"IntArrayList.of(SDK_NAME_HASH)");
        HashesList hashesList = new HashesList(intArrayList, false, 2, null);
        IntArrayList intArrayList2 = IntArrayList.of((int[])new int[]{hash});
        Intrinsics.checkNotNullExpressionValue((Object)intArrayList2, (String)"IntArrayList.of(hash)");
        return new SymbolHashesList(hashesList, new HashesList(intArrayList2, false, 2, null));
    }

    public final int getSdkNameHash() {
        return SDK_NAME_HASH;
    }

    private PwaJdkHashUtils() {
    }

    static {
        PwaJdkHashUtils pwaJdkHashUtils;
        INSTANCE = pwaJdkHashUtils = new PwaJdkHashUtils();
        NO_SDK_HASH = PwaHashUtils.hashText((String)"No sdk");
        SDK_NAME_HASH = PwaHashUtils.hashText((String)"sdk name");
    }
}

