/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.used;

import com.intellij.analysis.pwa.java.used.JavaUsedDependenciesVisitor;
import com.intellij.analysis.pwa.java.used.JavaUsedSymbolsSink;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001aM\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a&\u0010\u0019\u001a\u00020\u0006*\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"collectSuperClasses", "", "", "aClass", "Lcom/intellij/psi/PsiClass;", "collectSupersFromList", "", "extendsListTypes", "", "Lcom/intellij/psi/PsiClassType;", "passed", "Ljava/util/HashSet;", "queue", "Ljava/util/ArrayDeque;", "possibleClassNames", "containingFile", "Lcom/intellij/psi/PsiJavaFile;", "([Lcom/intellij/psi/PsiClassType;Ljava/util/HashSet;Ljava/util/ArrayDeque;Ljava/util/HashSet;Lcom/intellij/psi/PsiJavaFile;)V", "collectUsedDependencies", "file", "sink", "Lcom/intellij/analysis/pwa/java/used/JavaUsedSymbolsSink;", "emitCodeReferenceElement", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "emit", "qualifiedName", "referenceName", "onContent", "", "intellij.java.pwa"})
public final class JavaUsedSymbolsVisitorKt {
    private static final void emit(JavaUsedSymbolsSink $this$emit, String qualifiedName, String referenceName, boolean onContent) {
        if (qualifiedName == null) {
            $this$emit.emit(referenceName, onContent);
        } else {
            $this$emit.emit(qualifiedName + '.' + referenceName, onContent);
        }
    }

    public static final void emitCodeReferenceElement(@NotNull PsiJavaCodeReferenceElement reference, @NotNull JavaUsedSymbolsSink sink) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        PsiElement psiElement = reference.getQualifier();
        if (!(psiElement instanceof PsiJavaCodeReferenceElement)) {
            psiElement = null;
        }
        PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)psiElement;
        String name = reference.getReferenceName();
        if (name != null) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = qualifier;
            JavaUsedSymbolsVisitorKt.emit(sink, psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null, name, false);
        }
    }

    public static final void collectUsedDependencies(@NotNull PsiJavaFile file, @NotNull JavaUsedSymbolsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(file)");
        SyntaxTraverser traverser = syntaxTraverser;
        JavaUsedDependenciesVisitor dependenciesVisitor = new JavaUsedDependenciesVisitor(file, sink);
        for (PsiElement element : traverser) {
            element.accept((PsiElementVisitor)dependenciesVisitor);
        }
    }

    private static final Set<String> collectSuperClasses(PsiClass aClass) {
        ArrayDeque<PsiClass> queue = new ArrayDeque<PsiClass>();
        HashSet<PsiClass> passed = new HashSet<PsiClass>();
        HashSet<String> possibleClassNames = new HashSet<String>();
        queue.add(aClass);
        while (true) {
            PsiJavaFile containingFile;
            Collection collection = queue;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            PsiClass currentClass = (PsiClass)queue.removeFirst();
            passed.add(aClass);
            PsiClass psiClass = currentClass;
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"currentClass");
            PsiFile psiFile = psiClass.getContainingFile();
            if (!(psiFile instanceof PsiJavaFile)) {
                psiFile = null;
            }
            if ((PsiJavaFile)psiFile == null) {
                continue;
            }
            PsiClassType[] psiClassTypeArray = currentClass.getExtendsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"currentClass.extendsListTypes");
            JavaUsedSymbolsVisitorKt.collectSupersFromList(psiClassTypeArray, passed, queue, possibleClassNames, containingFile);
            PsiClassType[] psiClassTypeArray2 = currentClass.getImplementsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray2, (String)"currentClass.implementsListTypes");
            JavaUsedSymbolsVisitorKt.collectSupersFromList(psiClassTypeArray2, passed, queue, possibleClassNames, containingFile);
        }
        return possibleClassNames;
    }

    private static final void collectSupersFromList(PsiClassType[] extendsListTypes, HashSet<PsiClass> passed, ArrayDeque<PsiClass> queue, HashSet<String> possibleClassNames, PsiJavaFile containingFile) {
        for (PsiClassType type : extendsListTypes) {
            PsiJavaCodeReferenceElement ref;
            String simpleName;
            PsiClass superClass = type.resolve();
            if (superClass != null) {
                String qualifiedName;
                if (!passed.contains(superClass)) {
                    queue.add(superClass);
                }
                if ((qualifiedName = superClass.getQualifiedName()) == null) continue;
                possibleClassNames.add(qualifiedName);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)type.getName(), (String)"type.name");
            possibleClassNames.add(simpleName);
            PsiPackageStatement psiPackageStatement = containingFile.getPackageStatement();
            String packageName = psiPackageStatement != null ? psiPackageStatement.getPackageName() : null;
            PsiImportList imports = containingFile.getImportList();
            if (packageName != null) {
                possibleClassNames.add(packageName + '.' + simpleName);
            }
            if (imports == null) continue;
            PsiImportStatementBase specialImport = imports.findSingleImportStatement(simpleName);
            if (specialImport != null && (ref = specialImport.getImportReference()) != null) {
                possibleClassNames.add(ref.getQualifiedName());
            }
            for (PsiImportStatement importStatement : imports.getImportStatements()) {
                PsiJavaCodeReferenceElement importReference;
                if (importStatement instanceof PsiImportStaticStatement) continue;
                PsiImportStatement psiImportStatement = importStatement;
                Intrinsics.checkNotNullExpressionValue((Object)psiImportStatement, (String)"importStatement");
                if (!psiImportStatement.isOnDemand()) continue;
                if (importStatement.getImportReference() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)importReference, (String)"importStatement.importReference ?: continue");
                String importQualifiedName = importReference.getQualifiedName();
                if (importQualifiedName == null) continue;
                possibleClassNames.add(importQualifiedName + '.' + simpleName);
            }
        }
    }

    public static final /* synthetic */ Set access$collectSuperClasses(PsiClass aClass) {
        return JavaUsedSymbolsVisitorKt.collectSuperClasses(aClass);
    }

    public static final /* synthetic */ void access$emit(JavaUsedSymbolsSink $this$access_u24emit, String qualifiedName, String referenceName, boolean onContent) {
        JavaUsedSymbolsVisitorKt.emit($this$access_u24emit, qualifiedName, referenceName, onContent);
    }
}

