/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.used;

import com.intellij.analysis.pwa.java.used.JavaUsedSymbolsSink;
import com.intellij.analysis.pwa.java.utils.PwaJavaHashUtils;
import com.intellij.analysis.pwa.java.utils.PwaJdkHashUtils;
import com.intellij.analysis.pwa.java.utils.PwaLanguageLevelHashUtil;
import com.intellij.openapi.module.Module;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/analysis/pwa/java/used/HashingUsedSymbolsSink;", "Lcom/intellij/analysis/pwa/java/used/JavaUsedSymbolsSink;", "()V", "hashes", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "emit", "", "qualifiedName", "", "onContent", "", "emitJavaModuleDependency", "jpsModuleName", "emitLevelDependency", "module", "Lcom/intellij/openapi/module/Module;", "emitSdkDependency", "finish", "intellij.java.pwa"})
public final class HashingUsedSymbolsSink
implements JavaUsedSymbolsSink {
    private final IntArrayList hashes = new IntArrayList();

    @Override
    public void emit(@NotNull String qualifiedName, boolean onContent) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        int hash = onContent ? PwaJavaHashUtils.hashDependencyOnClassWithContent(qualifiedName) : PwaJavaHashUtils.hashDependencyName(qualifiedName);
        this.hashes.add(hash);
    }

    @Override
    public void emitJavaModuleDependency(@NotNull String jpsModuleName) {
        Intrinsics.checkNotNullParameter((Object)jpsModuleName, (String)"jpsModuleName");
        this.hashes.add(PwaJavaHashUtils.hashJavaModuleName(jpsModuleName));
    }

    @Override
    public void emitLevelDependency(@Nullable Module module) {
        int hash = module != null ? PwaLanguageLevelHashUtil.getModuleNameHash(module) : PwaLanguageLevelHashUtil.getProjectNameHash();
        this.hashes.add(hash);
    }

    @Override
    public void emitSdkDependency() {
        this.hashes.add(PwaJdkHashUtils.INSTANCE.getSdkNameHash());
    }

    @NotNull
    public final IntArrayList finish() {
        this.hashes.sort(IntComparators.NATURAL_COMPARATOR);
        return this.hashes;
    }
}

