/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.support;

import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.java.support.JavaFileAnalyser;
import com.intellij.analysis.pwa.support.PwaFileStateExtractor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaPwaFileStateExtractor;", "Lcom/intellij/analysis/pwa/support/PwaFileStateExtractor;", "project", "Lcom/intellij/openapi/project/Project;", "providerNameHash", "", "providerVersionFingerprint", "(Lcom/intellij/openapi/project/Project;II)V", "fileAnalyser", "Lcom/intellij/analysis/pwa/java/support/JavaFileAnalyser;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "extract", "Lcom/intellij/analysis/pwa/analyser/PwaFileState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.java.pwa"})
public final class JavaPwaFileStateExtractor
implements PwaFileStateExtractor {
    private final JavaFileAnalyser fileAnalyser;
    private final ProjectFileIndex projectFileIndex;

    @NotNull
    public PwaFileState extract(@NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiJavaFile cfr_ignored_0 = (PsiJavaFile)psiFile;
        return this.projectFileIndex.isInLibrary(file) ? this.fileAnalyser.analyseLibraryFile(file, (PsiJavaFile)psiFile) : this.fileAnalyser.analyseProjectFile(file, (PsiJavaFile)psiFile);
    }

    public JavaPwaFileStateExtractor(@NotNull Project project, int providerNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.fileAnalyser = new JavaFileAnalyser(project, providerNameHash, providerVersionFingerprint);
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        this.projectFileIndex = projectFileIndex;
    }
}

