/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.support;

import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaPwaFileFilter;", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "directoryIndex", "Lcom/intellij/openapi/roots/impl/DirectoryIndex;", "kotlin.jvm.PlatformType", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "fastShouldAnalyse", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldAnalyse", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.java.pwa"})
public final class JavaPwaFileFilter
implements PwaFileFilter {
    private final ProjectFileIndex projectFileIndex;
    private final DirectoryIndex directoryIndex;

    public boolean fastShouldAnalyse(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            return false;
        }
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)JavaFileType.INSTANCE);
    }

    public boolean shouldAnalyse(@NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        DirectoryInfo directoryInfo = this.directoryIndex.getInfoForFile(file);
        Intrinsics.checkNotNullExpressionValue((Object)directoryInfo, (String)"directoryIndex.getInfoForFile(file)");
        DirectoryInfo infoForFile = directoryInfo;
        if (this.directoryIndex.getSourceRootType(infoForFile) instanceof JavaResourceRootType) {
            return false;
        }
        return this.projectFileIndex.isInSource(file);
    }

    public JavaPwaFileFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        this.projectFileIndex = projectFileIndex;
        this.directoryIndex = DirectoryIndex.getInstance((Project)project);
    }
}

