/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.support;

import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.java.declared.HashingSymbolDeclarationSink;
import com.intellij.analysis.pwa.java.declared.JavaDeclaredDependenciesVisitor;
import com.intellij.analysis.pwa.java.used.HashingUsedSymbolsSink;
import com.intellij.analysis.pwa.java.used.JavaUsedDependenciesVisitor;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.analysis.pwa.utils.PwaIntListUtils;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaFileAnalyser;", "", "project", "Lcom/intellij/openapi/project/Project;", "providerNameHash", "", "providerVersionFingerprint", "(Lcom/intellij/openapi/project/Project;II)V", "analyseLibraryFile", "Lcom/intellij/analysis/pwa/analyser/PwaFileState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiJavaFile;", "analyseProjectFile", "analyzeFile", "bypassClassMembersRecursively", "", "aClass", "Lcom/intellij/psi/PsiClass;", "declaredDependenciesVisitor", "Lcom/intellij/analysis/pwa/java/declared/JavaDeclaredDependenciesVisitor;", "preResolve", "Companion", "PwaHighlightHolder", "intellij.java.pwa"})
public final class JavaFileAnalyser {
    private final Project project;
    private final int providerNameHash;
    private final int providerVersionFingerprint;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @RequiresReadLock
    @NotNull
    public final PwaFileState analyseProjectFile(@NotNull VirtualFile file, @NotNull PsiJavaFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        boolean bl = !this.project.isDisposed();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.analyzeFile(file, psiFile);
    }

    @NotNull
    public final PwaFileState analyseLibraryFile(@NotNull VirtualFile file, @NotNull PsiJavaFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        boolean bl = !this.project.isDisposed();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        int n = 0;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        HashingSymbolDeclarationSink declaredSink = new HashingSymbolDeclarationSink();
        JavaDeclaredDependenciesVisitor declaredSymbolsVisitor = new JavaDeclaredDependenciesVisitor(declaredSink, psiFile);
        PsiClass[] psiClassArray = psiFile.getClasses();
        int n2 = psiClassArray.length;
        for (n = 0; n < n2; ++n) {
            PsiClass aClass;
            PsiClass psiClass = aClass = psiClassArray[n];
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"aClass");
            this.bypassClassMembersRecursively(psiClass, declaredSymbolsVisitor);
        }
        int modCount = ManagingFS.getInstance().getModificationCount(file);
        SymbolHashesList declaredDependencies = declaredSink.finish();
        return new PwaFileState(new PwaFileOwnState(CollectionsKt.emptyList(), declaredDependencies, modCount, this.providerNameHash, this.providerVersionFingerprint), HashesList.Companion.getEMPTY());
    }

    private final void bypassClassMembersRecursively(PsiClass aClass, JavaDeclaredDependenciesVisitor declaredDependenciesVisitor) {
        aClass.accept((PsiElementVisitor)declaredDependenciesVisitor);
        for (PsiMethod psiMethod : aClass.getConstructors()) {
            psiMethod.accept((PsiElementVisitor)declaredDependenciesVisitor);
        }
        for (PsiMethod psiMethod : aClass.getFields()) {
            psiMethod.accept((PsiElementVisitor)declaredDependenciesVisitor);
        }
        for (PsiMethod psiMethod : aClass.getMethods()) {
            psiMethod.accept((PsiElementVisitor)declaredDependenciesVisitor);
        }
        PsiMethod[] psiMethodArray = aClass.getInnerClasses();
        int n = psiMethodArray.length;
        for (int j = 0; j < n; ++j) {
            PsiMethod psiMethod;
            PsiMethod psiMethod2 = psiMethod = psiMethodArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"innerClass");
            this.bypassClassMembersRecursively((PsiClass)psiMethod2, declaredDependenciesVisitor);
        }
    }

    @RequiresReadLock
    private final PwaFileState analyzeFile(VirtualFile file, PsiJavaFile psiFile) {
        Object e2;
        HashingUsedSymbolsSink usedSink = new HashingUsedSymbolsSink();
        JavaUsedDependenciesVisitor usedDependenciesVisitor = new JavaUsedDependenciesVisitor(psiFile, usedSink);
        HashingSymbolDeclarationSink declaredSink = new HashingSymbolDeclarationSink();
        JavaDeclaredDependenciesVisitor declaredSymbolsVisitor = new JavaDeclaredDependenciesVisitor(declaredSink, psiFile);
        boolean bl = false;
        List currentElementProblems = new ArrayList();
        PwaHighlightHolder problemHolder = new PwaHighlightHolder(psiFile, currentElementProblems);
        HighlightVisitorImpl highlightingVisitor2 = new HighlightVisitorImpl(problemHolder){
            final /* synthetic */ PwaHighlightHolder $problemHolder;
            {
                this.$problemHolder = $captured_local_variable$0;
                this.prepareToRunAsInspection($captured_local_variable$0);
            }
        };
        this.preResolve(psiFile);
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(psiFile)");
        SyntaxTraverser traverser = syntaxTraverser;
        HashMap allProblems = new HashMap();
        for (PsiElement element : traverser) {
            if (element instanceof PsiErrorElement) {
                String string = ((PsiErrorElement)element).getErrorDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.errorDescription");
                TextRange textRange = ((PsiErrorElement)element).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
                currentElementProblems.add(new PwaPersistentProblem(string, textRange.getStartOffset()));
            }
            try {
                element.accept((PsiElementVisitor)declaredSymbolsVisitor);
                element.accept((PsiElementVisitor)usedDependenciesVisitor);
                element.accept((PsiElementVisitor)highlightingVisitor2);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof ControlFlowException)) {
                    logger.warn("Error during PWA file analysis", e2);
                }
                throw e2;
            }
            e2 = currentElementProblems;
            boolean bl2 = false;
            if (!(!e2.isEmpty())) continue;
            Map map = allProblems;
            PsiElement psiElement = element;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
            map.put(psiElement, CollectionsKt.first((List)currentElementProblems));
            currentElementProblems.clear();
        }
        HashSet<PsiElement> toRemove = new HashSet<PsiElement>();
        e2 = allProblems.keySet().iterator();
        while (e2.hasNext()) {
            PsiElement elementWithError;
            PsiElement psiElement = elementWithError = (PsiElement)e2.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"elementWithError");
            for (PsiElement parent : SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(psiFile){
                final /* synthetic */ PsiJavaFile $psiFile;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$psiFile) ^ true;
                }
                {
                    this.$psiFile = psiJavaFile;
                    super(1);
                }
            }))) {
                if (!allProblems.containsKey(parent)) continue;
                toRemove.add(parent);
            }
        }
        for (PsiElement element : toRemove) {
            allProblems.remove(element);
        }
        IntArrayList dependencyHashes = usedSink.finish();
        SymbolHashesList declaredSymbolsHashesList = declaredSink.finish();
        IntArrayList sortedDependencyHashes = PwaIntListUtils.INSTANCE.sortDistinct(dependencyHashes);
        int modificationCount = ManagingFS.getInstance().getModificationCount(file);
        Collection collection = allProblems.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"allProblems.values");
        return new PwaFileState(new PwaFileOwnState(CollectionsKt.toList((Iterable)collection), declaredSymbolsHashesList, modificationCount, this.providerNameHash, this.providerVersionFingerprint), new HashesList(sortedDependencyHashes, false, 2, null));
    }

    private final void preResolve(PsiJavaFile psiFile) {
        for (PsiElement psiElement : SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)psiFile)).postOrderDfsTraversal()) {
            if (!(psiElement instanceof PsiJavaCodeReferenceElement)) continue;
            ((PsiJavaCodeReferenceElement)psiElement).resolve();
        }
    }

    public JavaFileAnalyser(@NotNull Project project, int providerNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.providerNameHash = providerNameHash;
        this.providerVersionFingerprint = providerVersionFingerprint;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JavaFileAnalyser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        JavaFileAnalyser.logger = logger;
    }

    @NotNull
    public static final Logger getLogger() {
        Companion companion = Companion;
        return logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaFileAnalyser$PwaHighlightHolder;", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "psiFile", "Lcom/intellij/psi/PsiJavaFile;", "problems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "(Lcom/intellij/psi/PsiJavaFile;Ljava/util/List;)V", "getProblems", "()Ljava/util/List;", "add", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "addAll", "highlightInfos", "", "addSingle", "", "hasErrorResults", "intellij.java.pwa"})
    private static final class PwaHighlightHolder
    extends HighlightInfoHolder {
        @NotNull
        private final List<PwaPersistentProblem> problems;

        public boolean add(@Nullable HighlightInfo info) {
            this.addSingle(info);
            return true;
        }

        public boolean addAll(@NotNull Collection<? extends HighlightInfo> highlightInfos) {
            Intrinsics.checkNotNullParameter(highlightInfos, (String)"highlightInfos");
            for (HighlightInfo highlightInfo : highlightInfos) {
                this.addSingle(highlightInfo);
            }
            return true;
        }

        private final void addSingle(HighlightInfo info) {
            if (info == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)info.getSeverity(), (Object)HighlightSeverity.ERROR) ^ true) {
                return;
            }
            int startOffset = info.startOffset;
            String string = info.getDescription();
            Intrinsics.checkNotNull((Object)string);
            this.problems.add(new PwaPersistentProblem(string, startOffset));
        }

        public boolean hasErrorResults() {
            Collection collection = this.problems;
            boolean bl = false;
            return !collection.isEmpty();
        }

        @NotNull
        public final List<PwaPersistentProblem> getProblems() {
            return this.problems;
        }

        public PwaHighlightHolder(@NotNull PsiJavaFile psiFile, @NotNull List<PwaPersistentProblem> problems) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter(problems, (String)"problems");
            super((PsiFile)psiFile, new HighlightInfoFilter[0]);
            this.problems = problems;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/analysis/pwa/java/support/JavaFileAnalyser$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.pwa"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

