/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java.declared;

import com.intellij.analysis.pwa.java.declared.ClassKind;
import com.intellij.analysis.pwa.java.declared.JavaClassCollectionSession;
import com.intellij.analysis.pwa.java.declared.JavaDeclaredDependenciesVisitor;
import com.intellij.analysis.pwa.java.declared.JavaSymbolDeclarationSink;
import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/analysis/pwa/java/declared/JavaDeclaredDependenciesVisitor;", "Lcom/intellij/psi/JavaElementVisitor;", "sink", "Lcom/intellij/analysis/pwa/java/declared/JavaSymbolDeclarationSink;", "file", "Lcom/intellij/psi/PsiJavaFile;", "(Lcom/intellij/analysis/pwa/java/declared/JavaSymbolDeclarationSink;Lcom/intellij/psi/PsiJavaFile;)V", "findQualifier", "", "place", "Lcom/intellij/psi/PsiElement;", "visitClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "visitModule", "module", "Lcom/intellij/psi/PsiJavaModule;", "intellij.java.pwa"})
public final class JavaDeclaredDependenciesVisitor
extends JavaElementVisitor {
    private final JavaSymbolDeclarationSink sink;
    private final PsiJavaFile file;

    public void visitClass(@NotNull PsiClass aClass) {
        int n;
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        super.visitClass(aClass);
        if (aClass instanceof PsiTypeParameter) {
            return;
        }
        String string = aClass.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.name ?: return");
        String className = string;
        if (PsiUtil.isLocalClass((PsiClass)aClass)) {
            return;
        }
        ClassKind kind = aClass.isAnnotationType() ? ClassKind.Annotation : (aClass.isInterface() ? ClassKind.Interface : (aClass.isRecord() ? ClassKind.Record : (aClass.isEnum() ? ClassKind.Enum : ClassKind.Class)));
        String classQualifier = this.findQualifier((PsiElement)aClass);
        JavaClassCollectionSession session = this.sink.startClassCollectionSession(aClass, classQualifier, className, kind, AnnotationTargetUtil.getAnnotationTargets((PsiClass)aClass));
        PsiField[] psiFieldArray = aClass.getFields();
        int n2 = psiFieldArray.length;
        for (n = 0; n < n2; ++n) {
            PsiField field;
            PsiField psiField = field = psiFieldArray[n];
            Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"field");
            String string2 = this.findQualifier((PsiElement)field);
            String string3 = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"field.name");
            session.emitField(psiField, string2, string3);
        }
        psiFieldArray = aClass.getMethods();
        n2 = psiFieldArray.length;
        for (n = 0; n < n2; ++n) {
            PsiField method;
            PsiField psiField = method = psiFieldArray[n];
            Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"method");
            String string4 = this.findQualifier((PsiElement)method);
            String string5 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"method.name");
            session.emitMethod((PsiMethod)psiField, string4, string5);
        }
        session.complete();
    }

    public void visitModule(@NotNull PsiJavaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.visitModule(module);
        Module module2 = ModuleUtilCore.findModuleForFile((PsiFile)((PsiFile)this.file));
        if (module2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"ModuleUtilCore.findModuleForFile(file) ?: return");
        Module jpsModule = module2;
        String string = jpsModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jpsModule.name");
        this.sink.emitModule(string, module);
    }

    private final String findQualifier(PsiElement place) {
        SmartList qualifiers = new SmartList();
        PsiElement current = place;
        while (current != null) {
            if (!((current = current.getParent()) instanceof PsiClass) || ((PsiClass)current).getName() == null) continue;
            qualifiers.add((Object)((PsiClass)current).getName());
            ((PsiClass)current).getQualifiedName();
        }
        String string = this.file.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.packageName");
        String packageName = string;
        CharSequence charSequence = packageName;
        boolean bl = false;
        if (charSequence.length() > 0) {
            qualifiers.add((Object)packageName);
        }
        if (qualifiers.isEmpty()) {
            return null;
        }
        CollectionsKt.reverse((List)((List)qualifiers));
        return CollectionsKt.joinToString$default((Iterable)((Iterable)qualifiers), (CharSequence)".", null, null, (int)0, null, (Function1)findQualifier.1.INSTANCE, (int)30, null);
    }

    public JavaDeclaredDependenciesVisitor(@NotNull JavaSymbolDeclarationSink sink, @NotNull PsiJavaFile file) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.sink = sink;
        this.file = file;
    }
}

