/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.java;

import com.intellij.analysis.pwa.debug.PwaDebugSymbol;
import com.intellij.analysis.pwa.debug.PwaDebugUsedSymbol;
import com.intellij.analysis.pwa.java.declared.JavaDeclaredDependenciesVisitor;
import com.intellij.analysis.pwa.java.declared.debug.DebugSymbolDeclarationSink;
import com.intellij.analysis.pwa.java.used.JavaUsedSymbolsVisitorKt;
import com.intellij.analysis.pwa.java.used.debug.JavaDebugUsedSymbolsSink;
import com.intellij.analysis.pwa.support.PwaDebugStateExtractor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/analysis/pwa/java/PwaJavaDebugFileStateCollector;", "Lcom/intellij/analysis/pwa/support/PwaDebugStateExtractor;", "()V", "extractSymbols", "", "Lcom/intellij/analysis/pwa/debug/PwaDebugSymbol;", "psiFile", "Lcom/intellij/psi/PsiFile;", "extractUsed", "Lcom/intellij/analysis/pwa/debug/PwaDebugUsedSymbol;", "intellij.java.pwa"})
public final class PwaJavaDebugFileStateCollector
implements PwaDebugStateExtractor {
    @NotNull
    public List<PwaDebugUsedSymbol> extractUsed(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        JavaDebugUsedSymbolsSink debugSymbolsSink = new JavaDebugUsedSymbolsSink();
        JavaUsedSymbolsVisitorKt.collectUsedDependencies(javaFile, debugSymbolsSink);
        return debugSymbolsSink.getDeps();
    }

    @NotNull
    public List<PwaDebugSymbol> extractSymbols(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        DebugSymbolDeclarationSink declarationSink = new DebugSymbolDeclarationSink(null, 1, null);
        JavaDeclaredDependenciesVisitor visitor = new JavaDeclaredDependenciesVisitor(declarationSink, javaFile);
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(psiFile)");
        SyntaxTraverser traverser = syntaxTraverser;
        for (PsiElement element : traverser) {
            element.accept((PsiElementVisitor)visitor);
        }
        return declarationSink.complete();
    }
}

