/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.a.g.g;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class RSADecoder {
    private final BigInteger a;
    private final BigInteger b;
    private final BigInteger d;
    private final int e;
    private final int c;

    public RSADecoder(BigInteger publicExponent, BigInteger publicModulus, int alphabetSize) {
        this.d = publicModulus;
        this.b = publicExponent;
        int n2 = publicModulus.bitLength();
        this.c = n2 / 8 - 1;
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.e = n3;
        this.a = new BigInteger(Integer.toString(alphabetSize));
    }

    public byte[] decode(String data) throws g {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BigInteger bigInteger = BigInteger.ZERO;
            int n2 = 0;
            for (int i10 = 0; i10 < data.length(); ++i10) {
                char c10 = data.charAt(i10);
                if (c10 == ' ' || c10 == '\t' || c10 == '\n' || c10 == '-') continue;
                bigInteger = bigInteger.multiply(this.a).add(RSADecoder.a(c10));
                if (++n2 != this.e) continue;
                BigInteger bigInteger2 = bigInteger.modPow(this.b, this.d);
                byte[] byArray = bigInteger2.toByteArray();
                byteArrayOutputStream.write(byArray, Math.max(byArray.length - this.c, 0), Math.min(byArray.length, this.c));
                bigInteger = BigInteger.ZERO;
                n2 = 0;
            }
            if (n2 != 0) {
                throw new g();
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private static BigInteger a(char c10) throws g {
        int n2;
        if ('0' <= c10 && c10 <= '9') {
            n2 = c10 - 48;
        } else if ('A' <= c10 && c10 <= 'Z') {
            n2 = c10 - 65 + 10;
        } else if ('a' <= c10 && c10 <= 'z') {
            n2 = c10 - 97 + 36;
        } else if ('!' <= c10 && c10 <= ')') {
            n2 = c10 - 33 + 62;
        } else {
            throw new g();
        }
        return BigInteger.valueOf(n2);
    }
}

