/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import b.h.la;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;
import org.jetbrains.intellij.build.dependencies.TeamCityHelper;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BuildDependenciesDownloader
implements GroovyObject {
    private static String a;
    private static /* synthetic */ ClassInfo e;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass b;
    private static /* synthetic */ Long c;
    private static /* synthetic */ ClassInfo d;
    private static final long f;

    @Generated
    public BuildDependenciesDownloader() {
        MetaClass metaClass;
        this.b = metaClass = this.$getStaticMetaClass();
    }

    public static void debug(String message) {
        DefaultGroovyMethods.println(BuildDependenciesDownloader.class, (Object)message);
    }

    public static void info(String message) {
        DefaultGroovyMethods.println(BuildDependenciesDownloader.class, (Object)message);
    }

    public static Path getCommunityRootFromWorkingDirectory() {
        long l2 = f ^ 0x345A10D47C8BL;
        Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path path2 = path;
        while (path2.getParent() != null) {
            Path path3;
            Object var4_32 = null;
            for (Object var4_32 : ScriptBytecodeAdapter.createList((Object[])new Object[]{".", "community", "ultimate/community"})) {
                Path path4 = path2.resolve(ShortTypeHandling.castToString(var4_32)).resolve("intellij.idea.community.main.iml");
                if (!Files.exists(path4, new LinkOption[0])) continue;
                return path4.getParent();
            }
            path2 = path3 = path2.getParent();
        }
        throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"IDEA Community root was not found from current working directory ", ""})));
    }

    public static Properties getDependenciesPropertiesFromWorkingDirectory() {
        long l2 = f ^ 0x55C6CB5A6319L;
        Path path = BuildDependenciesDownloader.getCommunityRootFromWorkingDirectory();
        Path path2 = path.resolve("build").resolve("dependencies").resolve("gradle.properties");
        DefaultGroovyMethods.println(BuildDependenciesDownloader.class, (Object)new GStringImpl(new Object[]{path2}, new String[]{"Loading properties from ", ""}));
        Reference reference = new Reference((Object)new Properties());
        public final class _getDependenciesPropertiesFromWorkingDirectory_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference a;
            private static /* synthetic */ ClassInfo b;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDependenciesPropertiesFromWorkingDirectory_closure1(Object _outerInstance, Object _thisObject, Reference properties) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.a = reference = properties;
            }

            public Object doCall(Object it2) {
                ((Properties)this.a.get()).load((Reader)ScriptBytecodeAdapter.castToType((Object)it2, Reader.class));
                return null;
            }

            @Generated
            public Properties getProperties() {
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.a.get(), Properties.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDependenciesPropertiesFromWorkingDirectory_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = b;
                if (classInfo == null) {
                    b = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IOGroovyMethods.withCloseable((Closeable)Files.newBufferedReader(path2), (Closure)new _getDependenciesPropertiesFromWorkingDirectory_closure1(BuildDependenciesDownloader.class, BuildDependenciesDownloader.class, reference));
        return (Properties)reference.get();
    }

    public static void checkCommunityRoot(Path communityRoot) {
        long l2 = f ^ 0x5B28A8F82E06L;
        if (communityRoot == null) {
            throw (Throwable)new IllegalStateException("passed community root is null");
        }
        Path path = communityRoot.resolve("intellij.idea.community.main.iml");
        if (!Files.exists(path, new LinkOption[0])) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{communityRoot}, new String[]{"community root was not found at ", ""})));
        }
    }

    private static Path a(Path path) {
        long l2 = f ^ 0x4583040E1D66L;
        BuildDependenciesDownloader.checkCommunityRoot(path);
        Path path2 = null;
        if (TeamCityHelper.getIsUnderTeamCity()) {
            Path path3;
            String string = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(TeamCityHelper.getSystemProperties(), (Object)"agent.persistent.cache"));
            if (string == null || string.isBlank()) {
                throw (Throwable)new IllegalStateException("'agent.persistent.cache' system property is required under TeamCity");
            }
            path2 = path3 = Paths.get(string, new String[0]);
        } else {
            Path path4;
            path2 = path4 = path.resolve("build").resolve("download");
        }
        Files.createDirectories(path2, new FileAttribute[0]);
        return path2;
    }

    public static synchronized Path downloadFileToCacheLocation(Path communityRoot, URI uri) {
        String string = uri.toString();
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        String string3 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)EncodingGroovyMethods.sha256((CharSequence)string2).substring(0, 10), (CharSequence)"-"), (CharSequence)string2);
        Path path = BuildDependenciesDownloader.a(communityRoot).resolve(string3);
        BuildDependenciesDownloader.downloadFile(uri, path);
        return path;
    }

    public static synchronized Path extractFileToCacheLocation(Path communityRoot, Path archiveFile) {
        long l2 = f ^ 0x10F10824150CL;
        String string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)EncodingGroovyMethods.sha256((CharSequence)archiveFile.toString()).substring(0, 6), (CharSequence)"-"), (CharSequence)archiveFile.getFileName().toString());
        Path path = BuildDependenciesDownloader.a(communityRoot).resolve(StringGroovyMethods.plus((String)string, (CharSequence)".d"));
        BuildDependenciesDownloader.extractFile(archiveFile, path);
        return path;
    }

    private static byte[] a(Path path) {
        int n2 = 1;
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{n2, path}, new String[]{"", "\n", "\n"})).getBytes(StandardCharsets.UTF_8);
    }

    private static boolean a(Path path, Path path2) {
        if (!Files.isRegularFile(path2, new LinkOption[0])) {
            return false;
        }
        byte[] byArray = Files.readAllBytes(path2);
        return ScriptBytecodeAdapter.compareEqual((Object)byArray, (Object)BuildDependenciesDownloader.a(path));
    }

    public static void extractFile(Path archiveFile, Path target) {
        long l2 = f ^ 0x46FFCA271BFCL;
        Path path = target.resolve(".flag.txt");
        if (BuildDependenciesDownloader.a(archiveFile, path)) {
            BuildDependenciesDownloader.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target}, new String[]{"Skipping extract to ", " since flag file is correct"})));
            Files.setLastModifiedTime(target, FileTime.from(Instant.now()));
            return;
        }
        if (Files.exists(target, new LinkOption[0])) {
            if (!Files.isDirectory(target, new LinkOption[0])) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target}, new String[]{"Target '", "' exists, but it's not a directory. Please delete it manually"})));
            }
            BuildDependenciesUtil.cleanDirectory(target);
        }
        BuildDependenciesDownloader.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{archiveFile, target}, new String[]{" * Extracting ", " to ", ""})));
        Files.createDirectories(target, new FileAttribute[0]);
        BuildDependenciesUtil.extractZip(archiveFile, target);
        Files.write(path, BuildDependenciesDownloader.a(archiveFile), new OpenOption[0]);
    }

    public static void downloadFile(URI uri, Path target) {
        long l2 = f ^ 0x378DA9F887DEL;
        if (Files.exists(target, new LinkOption[0])) {
            BuildDependenciesDownloader.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target, uri}, new String[]{"Target file ", " already exists, skipping download from ", ""})));
            Files.setLastModifiedTime(target, FileTime.from(Instant.now()));
            return;
        }
        BuildDependenciesDownloader.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri, target}, new String[]{" * Downloading ", " -> ", ""})));
        Reference reference = new Reference((Object)Files.createTempFile(target.getParent(), target.getFileName().toString(), ".tmp", new FileAttribute[0]));
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)uri.toURL().openConnection(), HttpURLConnection.class);
            boolean bl2 = true;
            httpURLConnection.setInstanceFollowRedirects(bl2);
            if (httpURLConnection.getResponseCode() != 200) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri, httpURLConnection.getResponseCode()}, new String[]{"Error download ", ": non-200 http status code ", ""})));
            }
            public final class _downloadFile_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference a;
                private static /* synthetic */ ClassInfo b;
                public static transient /* synthetic */ boolean __$stMC;

                public _downloadFile_closure2(Object _outerInstance, Object _thisObject, Reference tempFile) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.a = reference = tempFile;
                }

                public Object doCall(Object inputStream2) {
                    Reference reference = new Reference(inputStream2);
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference a;
                        private static /* synthetic */ ClassInfo b;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure3(Object _outerInstance, Object _thisObject, Reference inputStream2) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.a = reference = inputStream2;
                        }

                        public Object doCall(Object outputStream2) {
                            BuildDependenciesUtil.copyStream((InputStream)ScriptBytecodeAdapter.castToType((Object)this.a.get(), InputStream.class), (OutputStream)ScriptBytecodeAdapter.castToType((Object)outputStream2, OutputStream.class));
                            return null;
                        }

                        @Generated
                        public Object getInputStream() {
                            return this.a.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = b;
                            if (classInfo == null) {
                                b = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return IOGroovyMethods.withStream((OutputStream)new FileOutputStream(((Path)this.a.get()).toFile()), (Closure)new _closure3((Object)this, this.getThisObject(), reference));
                }

                @Generated
                public Object getTempFile() {
                    return this.a.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _downloadFile_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = b;
                    if (classInfo == null) {
                        b = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            IOGroovyMethods.withStream((InputStream)httpURLConnection.getInputStream(), (Closure)new _downloadFile_closure2(BuildDependenciesDownloader.class, BuildDependenciesDownloader.class, reference));
            long l3 = httpURLConnection.getHeaderFieldLong(a, c);
            if (l3 <= (long)0) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{a, uri}, new String[]{"Header '", "' is missing or zero for uri '", "'"})));
            }
            if (Files.size((Path)reference.get()) != l3) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri, (Path)reference.get(), l3, Files.size((Path)reference.get())}, new String[]{"Wrong file length after downloading uri '", "' to '", "': expected length ", " from Content-Length header, but got ", " on disk"})));
            }
            Files.move((Path)reference.get(), target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists((Path)reference.get());
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BuildDependenciesDownloader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = e;
        if (classInfo == null) {
            e = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.b;
        if (metaClass != null) {
            return metaClass;
        }
        this.b = this.$getStaticMetaClass();
        return this.b;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.b = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l2 = -1L;
        c = l2;
    }

    static {
        String string;
        f = la.a(-5968042193293266770L, -4516811209444826788L, MethodHandles.lookup().lookupClass()).a(249912933510582L);
        long l2 = f ^ 0x3065B9BEB5AFL;
        BuildDependenciesDownloader.__$swapInit();
        a = string = "Content-Length";
    }
}

