/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshConfigManagerBase
implements PersistentStateComponent<State> {
    @NotNull
    private SshConfigManager.ConfigsData b;
    @Nullable
    protected final com.intellij.openapi.project.Project myProject;
    private final List<Listener> c = new SmartList();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull String> a = new HashMap<String, String>();
    private static final long d = la.a(7708194580605739979L, 377780975694176209L, MethodHandles.lookup().lookupClass()).a(117227149625089L);

    private SshConfigManagerBase(@Nullable com.intellij.openapi.project.Project project) {
        this.myProject = project;
        this.b = new SshConfigManager.ConfigsData();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        MessageBusConnection messageBusConnection = this.myProject == null ? messageBus.connect() : messageBus.connect((Disposable)this.myProject);
        messageBusConnection.subscribe(SshConfigManager.SSH_CONFIG_AUTH, (Object)new SshConfigManager.SshConfigAuthListener(){
            private static final long a = la.a(-4319958653138777037L, 5470595383411119562L, MethodHandles.lookup().lookupClass()).a(255174024705187L);

            @Override
            public void sshConfigAuthDataChanged(@NotNull SshConfig sshConfig) {
                if (sshConfig == null) {
                    1.a(0);
                }
                this.a(sshConfig, SshConfigManagerBase.this.b.getLastSavedData());
                this.a(sshConfig, SshConfigManagerBase.this.b.getCurrentData());
            }

            private void a(@NotNull SshConfig sshConfig, List<SshUiData> list2) {
                SshUiData sshUiData;
                if (sshConfig == null) {
                    1.a(1);
                }
                if ((sshUiData = SshUiData.findById(list2, sshConfig.getId())) != null) {
                    sshUiData.reloadAuthDataFromPasswordSafe();
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x627BA0B2894FL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sshConfig";
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sshConfigAuthDataChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadAuthForConfig";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public State getState() {
        if (this.b.getLastSavedData().isEmpty()) {
            return null;
        }
        State state = new State();
        for (SshUiData sshUiData : this.b.getLastSavedData()) {
            SshConfig sshConfig = sshUiData.getConfig().clone();
            sshConfig.setProjectLevel(false);
            state.configs.add(sshConfig);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SshConfigManagerBase.a(0);
        }
        List<SshUiData> list2 = this.b.getCurrentData();
        ArrayList<SshUiData> arrayList = new ArrayList<SshUiData>();
        for (SshConfig sshConfig : state.configs) {
            sshConfig.setProjectLevel(this.myProject != null);
            arrayList.add(new SshUiData(sshConfig));
            this.a.putIfAbsent(sshConfig.getName(), sshConfig.getId());
        }
        this.b = new SshConfigManager.ConfigsData(arrayList, arrayList);
        this.a(new SshConfigManager.ConfigsData(list2, arrayList));
    }

    public SshConfigManager.ConfigsData getLastSavedAndCurrentData() {
        return this.b;
    }

    public void setCurrentData(@NotNull List<SshUiData> newData) {
        if (newData == null) {
            SshConfigManagerBase.a(1);
        }
        List<SshUiData> list2 = this.b.getCurrentData();
        this.b = this.b.createWithCurrentData(newData);
        this.a(new SshConfigManager.ConfigsData(list2, newData));
    }

    public void applyData(@NotNull List<SshUiData> data) {
        if (data == null) {
            SshConfigManagerBase.a(2);
        }
        List<SshUiData> list2 = this.b.getCurrentData();
        for (SshUiData sshUiData : this.b.getLastSavedData()) {
            String string = sshUiData.getConfig().getId();
            SshUiData sshUiData2 = SshUiData.findById(data, string);
            if (sshUiData2 != null) continue;
            sshUiData.getConfig().eraseAuthDataFromPasswordSafe();
        }
        for (SshUiData sshUiData : data) {
            sshUiData.saveAuthDataToPasswordSafe();
        }
        this.b = new SshConfigManager.ConfigsData(data, data);
        this.a(new SshConfigManager.ConfigsData(list2, data));
    }

    public void applyLastSavedData() {
        List<SshUiData> list2 = this.b.getCurrentData();
        @NotNull List<SshUiData> list3 = this.b.getLastSavedData();
        for (SshUiData sshUiData : list3) {
            sshUiData.saveAuthDataToPasswordSafe();
        }
        this.b = new SshConfigManager.ConfigsData(list3, list3);
        this.a(new SshConfigManager.ConfigsData(list2, list3));
    }

    public void addToSavedAndCurrent(SshUiData data) {
        List<SshUiData> list2 = this.b.getCurrentData();
        this.b = this.b.createMerged(new SshConfigManager.ConfigsData(data));
        this.a(new SshConfigManager.ConfigsData(list2, this.b.getCurrentData()));
    }

    @Nullable
    public SshUiData findExistingData(String host, String port2, String localPort, String username, AuthType type) {
        if (StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port2) || SshConfig.parseSshPort(port2) < 0) {
            return null;
        }
        for (SshUiData sshUiData : this.b.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (type != sshConfig.getAuthType() || !Objects.equals(host, sshConfig.getHost()) || !Objects.equals(port2, sshConfig.getLiteralPort()) || !Objects.equals(StringUtil.nullize((String)username, (boolean)true), StringUtil.nullize((String)sshConfig.getUsername(), (boolean)true))) continue;
            int n2 = SshConfig.parseSshPort(localPort);
            if (sshConfig.getLocalPort() != n2) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataName(@NotNull String name) {
        if (name == null) {
            SshConfigManagerBase.a(3);
        }
        for (SshUiData sshUiData : this.b.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(name, sshConfig.getName())) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByData(@NotNull PresentableId presentableId) {
        String string;
        if (presentableId == null) {
            SshConfigManagerBase.a(4);
        }
        if ((string = presentableId.getId()) == null) {
            return null;
        }
        for (SshUiData sshUiData : this.b.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(string, sshConfig.getId())) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataId(@NotNull String id2) {
        if (id2 == null) {
            SshConfigManagerBase.a(5);
        }
        for (SshUiData sshUiData : this.b.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(id2, sshConfig.getId())) continue;
            return sshUiData;
        }
        return null;
    }

    public void removeFromSavedAndCurrent(SshUiData data) {
        List<SshUiData> list2 = this.b.getCurrentData();
        Condition condition = sshUiData2 -> !sshUiData2.getConfig().getId().equals(data.getConfig().getId());
        List list3 = ContainerUtil.findAll(this.b.getLastSavedData(), (Condition)condition);
        List list4 = ContainerUtil.findAll(this.b.getCurrentData(), (Condition)condition);
        this.b = new SshConfigManager.ConfigsData(list3, list4);
        this.a(new SshConfigManager.ConfigsData(list2, list4));
    }

    public void addChangeListener(Listener listener) {
        this.c.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.c.remove(listener);
    }

    private void a(@NotNull SshConfigManager.ConfigsData configsData) {
        if (configsData == null) {
            SshConfigManagerBase.a(6);
        }
        SmartList smartList = new SmartList(this.c);
        for (Listener listener : smartList) {
            listener.changed(configsData);
        }
    }

    public String getIdFromInitialName(@NotNull String initialName) {
        if (initialName == null) {
            SshConfigManagerBase.a(7);
        }
        return this.a.get(initialName);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x53B444295B07L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyListeners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdFromInitialName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Listener {
        public void changed(@NotNull SshConfigManager.ConfigsData var1);
    }

    public static class State {
        @XCollection(style=XCollection.Style.v2, propertyElementName="configs")
        public List<SshConfig> configs = new ArrayList<SshConfig>();
    }

    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")})
    static final class App
    extends SshConfigManagerBase {
        App() {
            super(null);
        }
    }

    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")})
    static final class Project
    extends SshConfigManagerBase {
        private static final long e = la.a(3799745772028899437L, 7801037884223668879L, MethodHandles.lookup().lookupClass()).a(108765603543267L);

        Project(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.b(0);
            }
            super(project);
        }

        public com.intellij.openapi.project.Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = e ^ 0x7E5E3345E63BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ssh/config/unified/SshConfigManagerBase$Project", "<init>"));
        }
    }
}

