/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RsyncService;
import com.intellij.ssh.SSHUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSyncUtil {
    private static final Logger b;
    @NlsSafe
    public static final String RSYNC = "rsync";
    public static final String RSYNC_OPTIONS = "-zarv";
    public static final String RSYNC_SSH_PORT_OPTION = "-e";
    public static final String RSYNC_PORT_OPTION = "-p %s";
    public static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    public static final String RSYNC_SSH_OPTIONS = "ssh %s %s";
    private static final String a = "--log-file=%s";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private static final long c;

    public static boolean checkRsyncInstalled() {
        return RsyncService.getInstance().checkIfRSyncCommandExists();
    }

    public static boolean shouldInstallRSync() {
        long l2 = c ^ 0x353346A991A4L;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            return false;
        }
        if (!PlatformUtils.isRubyMine()) {
            return false;
        }
        return !RSyncUtil.checkRsyncInstalled();
    }

    public static boolean canUseRSync() {
        long l2 = c ^ 0x3CAECA23B6E7L;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync") || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled();
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2) throws ExecutionException {
        if (progressIndicator2 == null) {
            RSyncUtil.a(0);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator2));
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (indicatorWrapper == null) {
            RSyncUtil.a(1);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, true, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, boolean omitRemoteLastDirectoryNameIfNeeded, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (indicatorWrapper == null) {
            RSyncUtil.a(2);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, null, omitRemoteLastDirectoryNameIfNeeded, false, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @Nullable List<String> excludeElements, boolean omitRemoteLastDirectoryNameIfNeeded, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        Pair<String, List<String>> pair;
        long l2 = c ^ 0x202C8CF12730L;
        if (indicatorWrapper == null) {
            RSyncUtil.a(3);
        }
        if (omitRemoteLastDirectoryNameIfNeeded && (pair = PathUtilRt.getFileName((String)remotePath)).equals((Object)PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - pair.length());
        }
        pair = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, null, null, excludeElements, true);
        if (deleteFilesWithoutLocalPrototype) {
            ((List)pair.second).add("--delete");
        }
        RSyncUtil.a((String)pair.first, (List)pair.second, indicatorWrapper, credentials);
    }

    @ApiStatus.Experimental
    public static void uploadInBatchWithRSync(String sharedLocalPath, String sharedRemotePath, Collection<String> relativePaths, RemoteCredentials credentials, @Nullable List<String> excludeElements, boolean deleteFilesWithoutLocalPrototype, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        long l2 = c ^ 0x6A386B3B3113L;
        if (indicatorWrapper == null) {
            RSyncUtil.a(4);
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"fileList", (String)".txt");
            RSyncUtil.a(relativePaths, file);
            Pair<String, List<String>> pair = RSyncUtil.getRSyncCommandAndParameters(sharedLocalPath, sharedRemotePath, credentials, file, null, excludeElements, true);
            List list2 = (List)pair.second;
            if (deleteFilesWithoutLocalPrototype) {
                list2.add(list2.size() - 2, "--delete");
            }
            RSyncUtil.a((String)pair.first, list2, indicatorWrapper, credentials);
        }
        catch (IOException iOException) {
            throw new ExecutionException(SshBundle.message("dialog.message.rsync.failed.to.create.file.with.paths.to.upload", new Object[0]), (Throwable)iOException);
        }
        finally {
            if (file != null) {
                FileUtil.delete((File)file);
            }
        }
    }

    private static void a(Collection<String> collection, @NotNull File file) throws ExecutionException {
        long l2 = c ^ 0x4AC4E15964EBL;
        if (file == null) {
            RSyncUtil.a(5);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            boolean bl2 = true;
            for (String string : collection) {
                if (bl2) {
                    bl2 = false;
                } else {
                    ((OutputStream)fileOutputStream).write("\n".getBytes(StandardCharsets.UTF_8));
                }
                ((OutputStream)fileOutputStream).write(string.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            b.error((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ExecutionException(SshBundle.message("dialog.message.rsync.failed.to.write.paths.to.upload.to.file", new Object[0]), (Throwable)iOException);
        }
    }

    public static void testConnection(RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        long l2 = c ^ 0x3385EA39EBABL;
        if (indicatorWrapper == null) {
            RSyncUtil.a(6);
        }
        String string = Ssh.wrapIPv6Address(credentials.getHost());
        String string2 = RSyncUtil.a(credentials);
        String string3 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string4 = String.format(RSYNC_SSH_OPTIONS, string3, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-n");
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string4);
        arrayList.add(String.format("%s@%s:%s", credentials.getUserName(), string, ""));
        Pair pair = Pair.create((Object)RSYNC, arrayList);
        RSyncUtil.a((String)pair.first, (List)pair.second, indicatorWrapper, credentials);
    }

    private static String a(RemoteCredentials remoteCredentials) {
        long l2 = c ^ 0x2754A866046L;
        return !StringUtil.isEmpty((String)remoteCredentials.getPrivateKeyFile()) ? String.format(RSYNC_PUBLIC_KEY_OPTION, remoteCredentials.getPrivateKeyFile()) : "";
    }

    @Deprecated(since="2021.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void downloadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2, @Nullable File fileListPath, @Nullable String logfilePath) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.a(7);
        }
        if (remotePath == null) {
            RSyncUtil.a(8);
        }
        if (credentials == null) {
            RSyncUtil.a(9);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.a(10);
        }
        RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, progressIndicator2, fileListPath, logfilePath);
    }

    public static void downloadFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2, @Nullable File fileListPath, @Nullable String logfilePath) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.a(11);
        }
        if (remotePath == null) {
            RSyncUtil.a(12);
        }
        if (credentials == null) {
            RSyncUtil.a(13);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.a(14);
        }
        if (!((String)remotePath).endsWith(File.separator)) {
            remotePath = (String)remotePath + File.separator;
        }
        FileUtil.createDirectory((File)new File(localPath));
        Pair<String, List<String>> pair = RSyncUtil.getRSyncCommandAndParameters(localPath, (String)remotePath, credentials, fileListPath, logfilePath, null, false);
        RSyncUtil.a((String)pair.first, (List)pair.second, RSyncUtil.wrap(progressIndicator2), credentials);
    }

    public static void downloadFileOrFolderWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2, @Nullable File fileListPath, @Nullable String logfilePath) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.a(15);
        }
        if (remotePath == null) {
            RSyncUtil.a(16);
        }
        if (credentials == null) {
            RSyncUtil.a(17);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.a(18);
        }
        if (remotePath.endsWith(File.separator)) {
            RSyncUtil.downloadFolderWithRSync(localPath, remotePath, credentials, progressIndicator2, fileListPath, logfilePath);
            return;
        }
        Pair<String, List<String>> pair = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, fileListPath, logfilePath, null, false);
        RSyncUtil.a((String)pair.first, (List)pair.second, RSyncUtil.wrap(progressIndicator2), credentials);
    }

    public static void download(@NotNull List<? extends PathMappingSettings.PathMapping> pathMappings, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator2) throws ExecutionException {
        long l2 = c ^ 0x674064C756F8L;
        if (pathMappings == null) {
            RSyncUtil.a(19);
        }
        if (credentials == null) {
            RSyncUtil.a(20);
        }
        if (progressIndicator2 == null) {
            RSyncUtil.a(21);
        }
        Notification notification = null;
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"rsync_download", (String)".log");
            for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
                RSyncUtil.downloadFolderWithRSync(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot(), credentials, progressIndicator2, null, file.getPath());
            }
        }
        catch (IOException iOException) {
        }
        catch (SshRemoteHostIdentificationHasChangedException sshRemoteHostIdentificationHasChangedException) {
            String string = sshRemoteHostIdentificationHasChangedException.getMessage() + "\n" + SshBundle.message("rsync.ssh.remote.host.identification.has.changed.message", new Object[0]);
            notification = NOTIFICATION_GROUP.createNotification(string, NotificationType.ERROR);
        }
        if (notification == null) {
            notification = NOTIFICATION_GROUP.createNotification(SshBundle.message("rsync.download.complete.title", new Object[0]), NotificationType.INFORMATION);
            if (file != null) {
                final String string = file.getPath();
                b.debug(SshBundle.message("rsync.download.complete.message", string));
                notification.addAction((AnAction)new DumbAwareAction(SshBundle.messagePointer("action.Anonymous.text.log.file", new Object[0])){
                    private static final long a = la.a(8951494992009451716L, -4248738545723079368L, MethodHandles.lookup().lookupClass()).a(34205726825145L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            1.a(0);
                        }
                        RevealFileAction.openFile((File)new File(string));
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x776CA810759CL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/RSyncUtil$1", "actionPerformed"));
                    }
                });
            }
        }
        notification.notify(null);
    }

    private static void a(@NotNull String string, @NotNull List<String> list2, final @NotNull IndicatorWrapper indicatorWrapper, final @NotNull RemoteCredentials remoteCredentials) throws ExecutionException {
        File file;
        if (string == null) {
            RSyncUtil.a(22);
        }
        if (list2 == null) {
            RSyncUtil.a(23);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.a(24);
        }
        if (remoteCredentials == null) {
            RSyncUtil.a(25);
        }
        if ((file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)string)) == null) {
            b.warn("Command " + string + " not found in PATH");
            return;
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine().withConsoleMode(false);
        ptyCommandLine.setExePath(file.getPath());
        ptyCommandLine.addParameters(list2);
        b.debug("Running " + ptyCommandLine.getCommandLineString());
        final OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)ptyCommandLine);
        final PrintWriter printWriter = new PrintWriter(oSProcessHandler.getProcessInput());
        final Ref ref = new Ref();
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private final AnsiEscapeDecoder b = new AnsiEscapeDecoder();
            private final AnsiEscapeDecoder.ColoredTextAcceptor a = (string, key) -> {
                long l2 = c ^ 0x68CDC682A7FAL;
                indicatorWrapper.addText(string, key);
                if (SSHUtil.PASSPHRASE_PROMPT.matcher(string).matches()) {
                    this.a(remoteCredentials.getPassphrase());
                } else if (string.toLowerCase(Locale.getDefault()).contains("remote host identification has changed")) {
                    ref.set((Object)new SshRemoteHostIdentificationHasChangedException());
                    oSProcessHandler.destroyProcess();
                } else if (RSyncUtil.isPasswordRequired(string)) {
                    String string2 = remoteCredentials.getPassword() != null ? remoteCredentials.getPassword() : remoteCredentials.getUserName();
                    this.a(string2);
                } else if (string.contains("Are you sure you want to continue connecting")) {
                    this.a("yes");
                }
            };
            private static final long c = la.a(5827132750298926677L, 2489992509101976068L, MethodHandles.lookup().lookupClass()).a(264746730266423L);

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                long l2 = c ^ 0x71FAF49A9135L;
                if (event == null) {
                    2.a(0);
                }
                if (outputType == null) {
                    2.a(1);
                }
                try {
                    indicatorWrapper.checkCanceled();
                }
                catch (ProcessCanceledException processCanceledException) {
                    oSProcessHandler.destroyProcess();
                }
                String string = event.getText();
                if (string == null) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && !string.contains("No such file or directory")) {
                    b.info(string);
                }
                this.b.escapeText(string, outputType, this.a);
            }

            private void a(String string) {
                printWriter.println(string != null ? string : "");
                printWriter.flush();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.a(2);
                }
                indicatorWrapper.finished(event.getExitCode());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = c ^ 0x33C298E9689EL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ssh/RSyncUtil$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        oSProcessHandler.startNotify();
        while (!oSProcessHandler.waitFor(200L)) {
            if (indicatorWrapper.isCanceled()) {
                oSProcessHandler.destroyProcess();
            }
            indicatorWrapper.checkCanceled();
        }
        oSProcessHandler.waitFor();
        if (!indicatorWrapper.isCanceled() && oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() != 0) {
            b.warn("RSync exited with code: " + oSProcessHandler.getExitCode() + "\n\t" + ptyCommandLine.getCommandLineString());
        }
        if (!ref.isNull()) {
            throw (ExecutionException)((Object)ref.get());
        }
    }

    public static IndicatorWrapper wrap(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RSyncUtil.a(26);
        }
        return new IndicatorWrapper(){
            private static final long a = la.a(3627660035248969075L, 3184526197147298463L, MethodHandles.lookup().lookupClass()).a(189484882613536L);

            @Override
            public boolean isCanceled() {
                return indicator.isCanceled();
            }

            @Override
            public void checkCanceled() throws ProcessCanceledException {
                indicator.checkCanceled();
            }

            @Override
            public void addText(@NotNull @Nls String text, @NotNull Key<?> key) {
                if (text == null) {
                    3.a(0);
                }
                if (key == null) {
                    3.a(1);
                }
                if (key == ProcessOutputType.STDOUT && text.contains(File.separator)) {
                    indicator.setText(text);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6197F963AAD0L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$3";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static boolean isPasswordRequired(String text) {
        long l2 = c ^ 0x9B5EAB383E5L;
        String string = text.trim().toLowerCase(Locale.getDefault());
        return string.startsWith("password for") || string.endsWith("password:");
    }

    static Pair<String, List<String>> getRSyncCommandAndParameters(String localPath, String remotePath, RemoteCredentials credentials, @Nullable File fileListPath, @Nullable String logfilePath, @Nullable List<String> excludeElements, boolean isServerSideModification) {
        String string;
        String string2;
        long l2 = c ^ 0x37D3B04A6F57L;
        remotePath = StringUtil.escapeChars((String)remotePath, (char[])new char[]{' ', '$'});
        localPath = RSyncUtil.a(localPath);
        String string3 = Ssh.wrapIPv6Address(credentials.getHost());
        String string4 = String.format("%s@%s:%s", credentials.getUserName(), string3, remotePath);
        if (isServerSideModification) {
            string2 = localPath;
            string = string4;
        } else {
            string2 = string4;
            string = localPath;
        }
        String string5 = RSyncUtil.a(credentials);
        String string6 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string7 = String.format(RSYNC_SSH_OPTIONS, string6, string5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(RSYNC_OPTIONS);
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string7);
        if (logfilePath != null) {
            arrayList.add(String.format(a, logfilePath));
        }
        if (fileListPath != null) {
            arrayList.add("--files-from=" + RSyncUtil.a(FileUtil.toSystemIndependentName((String)fileListPath.getPath())));
        }
        if (excludeElements != null) {
            for (String string8 : excludeElements) {
                arrayList.add("--exclude=" + string8);
            }
        }
        arrayList.add(string2);
        arrayList.add(string);
        return Pair.create((Object)RSYNC, arrayList);
    }

    private static String a(String object) {
        if (Platform.current() == Platform.WINDOWS && !((String)object).startsWith("/") && ((String)object).length() > 1 && ((String)object).charAt(1) == ':') {
            object = "/cygdrive/" + ((String)object).charAt(0) + ((String)object).substring(2).replace('\\', '/');
        }
        return object;
    }

    static {
        c = la.a(-9076940831699855040L, 7778108318377063798L, MethodHandles.lookup().lookupClass()).a(262720535878287L);
        long l2 = c ^ 0x60900F16B74CL;
        b = Logger.getInstance(RSyncUtil.class);
        NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Remote Transfer", (String)SshBundle.message("notification.group.name", new Object[0]));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x5FA972C8F172L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/RSyncUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadWithRSync";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadInBatchWithRSync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writePaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "testConnection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadWithRSync";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadFolderWithRSync";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadFileOrFolderWithRSync";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "download";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndListenBashCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface IndicatorWrapper {
        public boolean isCanceled();

        public void checkCanceled() throws ProcessCanceledException;

        public void addText(@NotNull @Nls String var1, @NotNull Key<?> var2);

        default public void finished(int exitCode) {
        }
    }
}

