/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.JSchUtilsKt;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelConfig;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.SshSessionKt;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.SshTunnelCreationException;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.impl.channels.ExecChannelImpl;
import com.intellij.ssh.impl.channels.SftpChannelImpl;
import com.intellij.ssh.impl.channels.ShellChannelImpl;
import com.intellij.ssh.process.NullInputStream;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'H\u0016J+\u0010(\u001a\u0002H)\"\b\b\u0000\u0010)*\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H)0,H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010$\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010$\u001a\u000205H\u0016J\b\u00106\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\n\u00a8\u00068"}, d2={"Lcom/intellij/ssh/JschSshSession;", "Lcom/intellij/ssh/SshSessionChannelFactory;", "d", "Lcom/jcraft/jsch/Session;", "e", "Lcom/intellij/ssh/config/SshConnectionConfig;", "(Lcom/jcraft/jsch/Session;Lcom/intellij/ssh/config/SshConnectionConfig;)V", "host", "", "getHost", "()Ljava/lang/String;", "isConnected", "", "()Z", "c", "Ljava/util/concurrent/atomic/AtomicBoolean;", "b", "port", "", "getPort", "()I", "getRawSession", "()Lcom/jcraft/jsch/Session;", "userName", "getUserName", "addLocalTunnel", "", "localPort", "remotePort", "addLocalTunnelWithRandomLocalPort", "addRemoteTunnel", "addRemoteTunnelWithRandomRemotePort", "applyPortForwardings", "disconnect", "execChannel", "Lcom/intellij/ssh/channels/ExecChannel;", "channelConfig", "Lcom/intellij/ssh/ExecChannelConfig;", "getPortForwardingList", "", "openChannel", "C", "Lcom/intellij/ssh/channels/SshChannel;", "channelCreator", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "removeLocalTunnel", "removeRemoteTunnel", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/SftpChannelConfig;", "shellChannel", "Lcom/intellij/ssh/channels/ShellChannel;", "Lcom/intellij/ssh/ShellChannelConfig;", "toString", "Companion", "intellij.platform.ssh"})
public final class JschSshSession
implements SshSessionChannelFactory {
    private final Session b;
    private final AtomicBoolean c;
    @NotNull
    private final Session d;
    private final SshConnectionConfig e;
    private static final Logger a;
    @NotNull
    public static final Companion Companion;
    private static final long f;

    @Override
    @NotNull
    public <C extends SshChannel> C openChannel(@NotNull Function1<? super SshSessionChannelFactory, ? extends C> channelCreator) throws SshTransportException {
        long l2 = f ^ 0x2FCBE2C5982FL;
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        try {
            return (C)((SshChannel)channelCreator.invoke((Object)this));
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTransportException(jSchException.getMessage(), jSchException));
        }
    }

    @Override
    public void addRemoteTunnel(int remotePort, @NotNull String host, int localPort) throws SshTransportException {
        long l2 = f ^ 0x2A9E824771D0L;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        a.debug("Adding remote tunnel " + host + ':' + localPort + " <= " + remotePort + " for " + this);
        try {
            this.b.setPortForwardingR(remotePort, host, localPort);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTunnelCreationException("Failed to add remote port forwarding", jSchException));
        }
    }

    @Override
    public int addRemoteTunnelWithRandomRemotePort(@NotNull String host, int localPort) throws SshTransportException {
        int n2;
        long l2 = f ^ 0x20F7B8EC1283L;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        a.debug("Adding remote tunnel " + host + ':' + localPort + " <= <random port> for " + this);
        try {
            n2 = JSchUtilsKt.setPortForwardingRAllocateUnchecked(this.b, host, localPort);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTunnelCreationException("Failed to add remote port forwarding", jSchException));
        }
        int n3 = n2;
        a.debug("Added remote tunnel " + host + ':' + localPort + " <= " + n3 + " (requested as random) for " + this);
        return n3;
    }

    @Override
    public void addLocalTunnel(int localPort, @NotNull String host, int remotePort) throws SshTransportException {
        long l2 = f ^ 0x5058AF45AC3FL;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        a.debug("Adding local tunnel " + localPort + " => " + host + ':' + remotePort + " for " + this);
        try {
            this.b.setPortForwardingL(localPort, host, remotePort);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTunnelCreationException("Failed to add local port forwarding", jSchException));
        }
    }

    @Override
    public int addLocalTunnelWithRandomLocalPort(@NotNull String host, int remotePort) throws SshTransportException {
        int n2;
        long l2 = f ^ 0x49D39B36C1BFL;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        a.debug("Adding local tunnel <random port> => " + host + ':' + remotePort + " for " + this);
        try {
            n2 = this.b.setPortForwardingL(0, host, remotePort);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTunnelCreationException("Failed to add local port forwarding", jSchException));
        }
        int n3 = n2;
        a.debug("Added local tunnel " + n3 + " (requested as random) <= " + host + ':' + remotePort + " for " + this);
        return n3;
    }

    @Override
    @NotNull
    public List<String> getPortForwardingList() {
        List<String> list2;
        long l2 = f ^ 0x23F1733191D1L;
        try {
            String[] stringArray = this.b.getPortForwardingL();
            List<String> list3 = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue(list3, (String)"Arrays.asList(*jschRawSession.portForwardingL)");
            list2 = list3;
        }
        catch (JSchException jSchException) {
            List<String> list4 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"Collections.emptyList<String>()");
            list2 = list4;
        }
        return list2;
    }

    @Override
    public void removeLocalTunnel(int port2) throws SshTransportException {
        long l2 = f ^ 0x64098CA1880BL;
        a.debug("Deleting local tunnel bound to local port " + port2);
        try {
            this.b.delPortForwardingL(port2);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTransportException("Failed to delete local port forwarding"));
        }
    }

    @Override
    public void removeRemoteTunnel(int port2) throws SshTransportException {
        long l2 = f ^ 0x703EFB4402E8L;
        a.debug("Deleting remote tunnel bound to local port " + port2);
        try {
            this.b.delPortForwardingR(port2);
        }
        catch (JSchException jSchException) {
            throw (Throwable)((Object)new SshTransportException("Failed to delete remote port forwarding"));
        }
    }

    @Override
    public void disconnect() {
        long l2 = f ^ 0x4F01BE20A57L;
        if (this.c.compareAndSet(false, true)) {
            a.debug("Disconnecting " + this);
            this.b.disconnect();
        }
    }

    @Override
    @NotNull
    public ExecChannel execChannel(@NotNull ExecChannelConfig channelConfig) {
        Object object;
        Object object2;
        long l2 = f ^ 0x58A78847F362L;
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        Channel channel2 = this.b.openChannel("exec");
        if (channel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jcraft.jsch.ChannelExec");
        }
        ChannelExec channelExec = (ChannelExec)channel2;
        channelExec.setPty(channelConfig.isPty());
        channelExec.setCommand(channelConfig.getCommand());
        X11Forwarding x11Forwarding = this.e.getX11Forwarding();
        if (x11Forwarding != null) {
            object2 = x11Forwarding;
            boolean bl2 = false;
            boolean bl3 = false;
            object = object2;
            boolean bl4 = false;
            channelExec.setXForwarding(true);
        }
        object2 = channelExec.getOutputStream();
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        if (channelConfig.getRedirectErrorStream()) {
            inputStream2 = new NullInputStream();
            inputStream3 = new PipedInputStream();
            object = new PipedOutputStream((PipedInputStream)inputStream3);
            channelExec.setErrStream((OutputStream)object);
            channelExec.setOutputStream((OutputStream)object);
        } else {
            InputStream inputStream4 = channelExec.getErrStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream4, (String)"channel.errStream");
            inputStream2 = inputStream4;
            InputStream inputStream5 = channelExec.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream5, (String)"channel.inputStream");
            inputStream3 = inputStream5;
        }
        channelExec.connect(channelConfig.getTimeoutInMillis());
        return new ExecChannelImpl((SshSession)this, channelExec, channelConfig.isPty(), inputStream3, (OutputStream)object2, inputStream2);
    }

    @Override
    @NotNull
    public SftpChannel sftpChannel(@NotNull SftpChannelConfig channelConfig) {
        long l2 = f ^ 0x1B8F1CEA5656L;
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        Channel channel2 = this.b.openChannel("sftp");
        if (channel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
        }
        ChannelSftp channelSftp = (ChannelSftp)channel2;
        if (channelConfig.getDecoratorClass() != null) {
            try {
                Constructor<?> constructor = channelConfig.getDecoratorClass().getConstructor(ChannelSftp.class);
                Object obj = constructor.newInstance(channelSftp);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
                }
                channelSftp = (ChannelSftp)obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        channelSftp.connect(channelConfig.getTimeoutInMillis());
        return new SftpChannelImpl(this, channelSftp);
    }

    @Override
    @NotNull
    public ShellChannel shellChannel(@NotNull ShellChannelConfig channelConfig) {
        long l2 = f ^ 0x51C200F56B56L;
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        Channel channel2 = this.b.openChannel("shell");
        if (channel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jcraft.jsch.ChannelShell");
        }
        ChannelShell channelShell = (ChannelShell)channel2;
        InputStream inputStream2 = null;
        OutputStream outputStream2 = null;
        channelShell.setPty(channelConfig.isPty());
        channelShell.setPtyType("xterm-256color");
        channelShell.setEnv("LANG", "en_US.UTF-8");
        X11Forwarding x11Forwarding = this.e.getX11Forwarding();
        if (x11Forwarding != null) {
            X11Forwarding x11Forwarding2 = x11Forwarding;
            boolean bl2 = false;
            boolean bl3 = false;
            X11Forwarding x11Forwarding3 = x11Forwarding2;
            boolean bl4 = false;
            channelShell.setXForwarding(true);
        }
        inputStream2 = channelShell.getInputStream();
        outputStream2 = channelShell.getOutputStream();
        channelShell.connect(channelConfig.getTimeoutInMillis());
        return new ShellChannelImpl((SshSession)this, channelShell, inputStream2, outputStream2);
    }

    @Override
    public void applyPortForwardings() {
        boolean bl2;
        OpenSshConfigForwardInfo openSshConfigForwardInfo;
        long l2 = f ^ 0x778E8A2497E7L;
        if (Intrinsics.areEqual((Object)this.b.getConfig("ClearAllForwardings"), (Object)"yes")) {
            return;
        }
        Iterable iterable = this.e.getInitialLocalTcpForwardings();
        boolean bl3 = false;
        for (Object t2 : iterable) {
            openSshConfigForwardInfo = (OpenSshConfigForwardInfo)t2;
            bl2 = false;
            try {
                this.b.setPortForwardingL(openSshConfigForwardInfo.getBindHost() + ':' + openSshConfigForwardInfo.getBindPort() + ':' + openSshConfigForwardInfo.getHost() + ':' + openSshConfigForwardInfo.getPort());
            }
            catch (JSchException jSchException) {
                SshSessionKt.access$logPortForwardingException("LocalForward \"" + openSshConfigForwardInfo + '\"', jSchException);
            }
        }
        iterable = this.e.getInitialRemoteTcpForwardings();
        bl3 = false;
        for (Object t2 : iterable) {
            openSshConfigForwardInfo = (OpenSshConfigForwardInfo)t2;
            bl2 = false;
            try {
                this.b.setPortForwardingR(openSshConfigForwardInfo.getBindHost() + ':' + openSshConfigForwardInfo.getBindPort() + ':' + openSshConfigForwardInfo.getHost() + ':' + openSshConfigForwardInfo.getPort());
            }
            catch (JSchException jSchException) {
                SshSessionKt.access$logPortForwardingException("RemoteForward \"" + openSshConfigForwardInfo + '\"', jSchException);
            }
        }
    }

    @NotNull
    public String toString() {
        long l2 = f ^ 0x1FBA1458E341L;
        return "SSH session " + SshConnectionUtil.id(this) + " to " + this.getUserName() + '@' + this.getHost() + ':' + this.getPort();
    }

    @Override
    @NotNull
    public String getUserName() {
        long l2 = f ^ 0x5B4ECEE73BE2L;
        String string = this.b.getUserName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jschRawSession.userName");
        return string;
    }

    @Override
    @NotNull
    public String getHost() {
        long l2 = f ^ 0x5DCC25F47FAFL;
        String string = this.b.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jschRawSession.host");
        return string;
    }

    @Override
    public int getPort() {
        return this.b.getPort();
    }

    @Override
    public boolean isConnected() {
        return this.b.isConnected();
    }

    @Override
    @NotNull
    public Session getRawSession() {
        return this.d;
    }

    public JschSshSession(@NotNull Session rawSession, @NotNull SshConnectionConfig connectionConfig) {
        long l2 = f ^ 0x657B13A33DF5L;
        Intrinsics.checkNotNullParameter((Object)rawSession, (String)"rawSession");
        Intrinsics.checkNotNullParameter((Object)connectionConfig, (String)"connectionConfig");
        this.d = rawSession;
        this.e = connectionConfig;
        this.b = this.getRawSession();
        this.c = new AtomicBoolean(false);
    }

    static {
        f = la.a(1106059194632815031L, 2784451374830096873L, MethodHandles.lookup().lookupClass()).a(76887194414051L);
        long l2 = f ^ 0x4F0923877B1AL;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SshSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(SshSession::class.java)");
        a = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ssh/JschSshSession$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

