/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.base.YList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Graph2DViewActions;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.StandardGraphViewControllerBuilder;
import com.intellij.openapi.graph.view.View2DConstants;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    @NotNull
    private static final Logger l;
    @NotNull
    private final Project q;
    @NotNull
    private final Graph2DView e;
    @NotNull
    private final Graph2D c;
    @NotNull
    private final HierarchyManager d;
    @NotNull
    private final GraphDataMaps<N, E> h;
    @NotNull
    private final GraphUpdateModel j;
    @NotNull
    private final GraphDataModel<N, E> k;
    @NotNull
    private final GraphPresentationModel<N, E> m;
    @NotNull
    private final MergingUpdateQueue i;
    @NotNull
    private final AtomicBoolean a;
    @NotNull
    private final AtomicBoolean f;
    @NotNull
    private final AtomicBoolean g;
    @NotNull
    private final Set<CustomGraphUpdater> p;
    @GuardedBy(value="this")
    @NotNull
    private final EventDispatcher<GraphBuilderListener> n;
    @Nullable
    private EditMode b;
    @Nullable
    private ViewMode o;
    private static final long r;

    @Deprecated
    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel) {
        if (project == null) {
            GraphBuilderImpl.a(0);
        }
        if (graph == null) {
            GraphBuilderImpl.a(1);
        }
        if (view == null) {
            GraphBuilderImpl.a(2);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.a(3);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.a(4);
        }
        this(project, graph, view, graphDataModel, graphPresentationModel, null);
    }

    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel, @Nullable EditMode editMode) {
        long l2 = r ^ 0x3C71D80DF1L;
        if (project == null) {
            GraphBuilderImpl.a(5);
        }
        if (graph == null) {
            GraphBuilderImpl.a(6);
        }
        if (view == null) {
            GraphBuilderImpl.a(7);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.a(8);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.a(9);
        }
        this.a = new AtomicBoolean(false);
        this.f = new AtomicBoolean(false);
        this.g = new AtomicBoolean(false);
        this.p = new HashSet<CustomGraphUpdater>();
        this.n = EventDispatcher.create(GraphBuilderListener.class);
        this.q = project;
        this.c = graph;
        this.e = view;
        this.h = new GraphDataMaps();
        this.d = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.k = graphDataModel;
        this.m = graphPresentationModel;
        this.j = new GraphUpdateModel((Graph)graph);
        this.i = new MergingUpdateQueue("YFiles", 100, true, this.e.getJComponent(), (Disposable)this, null, true);
        this.d();
        Disposer.register((Disposable)this, this.k);
        Disposer.register((Disposable)this, this.m);
        Disposer.register((Disposable)this, (Disposable)this.i);
        this.b = editMode;
        this.o = this.b;
    }

    public final void initialize() {
        if (this.a.compareAndSet(false, true)) {
            WriteAction.runAndWait(() -> {
                this.a();
                this.updateGraph();
            });
        }
    }

    private void a() {
        WriteAction.runAndWait(() -> {
            this.e.setGraph2D(this.getGraph());
            this.e.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
            GraphBuilderImpl.b(this.e);
            GraphBuilderImpl.a(this.e);
            if (this.b == null) {
                this.b = this.createDefaultEditMode();
                this.o = this.b;
                this.setupViewControllers(this.b);
            }
            this.getGraphPresentationModel().customizeSettings(this.getView(), this.b);
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode) {
        void editMode2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editMode2 == null) {
            GraphBuilderImpl.a(10);
        }
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(200);
        ((StandardGraphViewControllerBuilder)((StandardGraphViewControllerBuilder)StandardGraphViewControllerBuilder.beginSetupFor((GraphBuilder)this, this.n).setEditMode((EditMode)editMode2)).setMagnifierViewMode(magnifierViewMode)).endSetup();
    }

    @RequiresEdt
    @NotNull
    protected EditMode createDefaultEditMode() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditMode editMode = GraphEditModeFactory.getInstance((Project)this.getProject()).createEditMode((GraphBuilder)this);
        editMode.assignNodeLabel(false);
        editMode.allowResizeNodes(true);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(true);
        editMode.allowMoveLabels(true);
        editMode.allowMovePorts(true);
        editMode.allowMoveSelection(true);
        editMode.allowMovingWithPopup(true);
        editMode.showNodeTips(true);
        editMode.showEdgeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            GraphBuilderImpl.a(11);
        }
        return editMode2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateGraph(boolean bl2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            void doLayout;
            this.updateDataModel();
            this.updateView((boolean)doLayout);
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    @RequiresEdt
    public void updateDataModel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.a()) {
            this.initialize();
        }
        this.updateDataMapsFromDataModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.b((Graph)this.getGraph());
        this.a((Graph)this.getGraph());
    }

    private void a(@NotNull Graph graph) {
        if (graph == null) {
            GraphBuilderImpl.a(12);
        }
        Set set = this.getDataMaps().getEdgeObjectDataBiMap().keySet();
        for (Edge edge : set.toArray(new Edge[0])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void b(@NotNull Graph graph) {
        if (graph == null) {
            GraphBuilderImpl.a(13);
        }
        for (Node node : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node) && !this.isGroupNode(node)) {
                this.getDataMaps().removeNode(node);
                graph.removeNode(node);
            }
            if (!this.getHierarchyManager().isFolderNode(node)) continue;
            this.b(this.getHierarchyManager().getInnerGraph(node));
            this.a(this.getHierarchyManager().getInnerGraph(node));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateView(boolean bl2) {
        void doLayout;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateRealizers(false);
        this.updateBridges();
        this.updateGroups();
        for (CustomGraphUpdater customGraphUpdater : this.p) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        if (doLayout != false) {
            this.f();
        }
        this.getGraph().updateViews();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRealizers(boolean bl2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            void updateAllNodes;
            this.updateNodeRealizer((boolean)updateAllNodes, node);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            this.updateEdgeRealizer(edge);
        }
    }

    protected void updateNodeRealizer(boolean updateAllNodes, @NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.a(14);
        }
        if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node) && (updateAllNodes || this.isNodeWasCreated(node))) {
            this.getGraph().setRealizer(node, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node)));
        }
        GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node);
    }

    protected void updateEdgeRealizer(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilderImpl.a(15);
        }
        EdgeRealizer edgeRealizer = this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge));
        if (this.isEdgeWasCreated(edge)) {
            this.getGraph().setRealizer(edge, edgeRealizer);
            this.updateEdgeLabels(edge, null, edgeRealizer);
        } else {
            YList yList = this.getGraph().getPathList(edge);
            EdgeRealizer edgeRealizer2 = this.getGraph().getRealizer(edge);
            this.getGraph().setRealizer(edge, edgeRealizer);
            this.getGraph().setPath(edge, yList);
            this.updateEdgeLabels(edge, edgeRealizer2, edgeRealizer);
        }
    }

    protected void updateEdgeLabels(@NotNull Edge edge, @Nullable EdgeRealizer oldEdgeRealizer, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilderImpl.a(16);
        }
        if (newEdgeRealizer == null) {
            GraphBuilderImpl.a(17);
        }
        EdgeLabel[] edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge));
        Map<String, List<EdgeLabel>> map = GraphBuilderImpl.a(oldEdgeRealizer).stream().collect(Collectors.groupingBy(edgeLabel -> edgeLabel.getText()));
        for (EdgeLabel edgeLabel2 : edgeLabelArray) {
            List<EdgeLabel> list2 = map.get(edgeLabel2.getText());
            if (list2 != null && list2.size() > 0) {
                EdgeLabel edgeLabel3 = list2.remove(list2.size() - 1);
                edgeLabel2.setLabelModel(edgeLabel3.getLabelModel(), edgeLabel3.getModelParameter());
            }
            newEdgeRealizer.addLabel(edgeLabel2);
        }
    }

    @NotNull
    private static List<EdgeLabel> a(@Nullable EdgeRealizer edgeRealizer) {
        if (edgeRealizer == null) {
            List<EdgeLabel> list2 = Collections.emptyList();
            if (list2 == null) {
                GraphBuilderImpl.a(18);
            }
            return list2;
        }
        int n2 = edgeRealizer.labelCount();
        ArrayList<EdgeLabel> arrayList = new ArrayList<EdgeLabel>();
        for (int i10 = 0; i10 < n2; ++i10) {
            arrayList.add(edgeRealizer.getLabel(i10));
        }
        ArrayList<EdgeLabel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphBuilderImpl.a(19);
        }
        return arrayList2;
    }

    protected void updateBridges() {
        ObjectUtils.consumeIfCast(this.getGraphPresentationModel(), BasicGraphPresentationModel.class, basicGraphPresentationModel -> basicGraphPresentationModel.setupBridgesFor(this.getView().getGraph2DRenderer()));
    }

    private void f() {
        if (this.getGraph().nodeCount() > 0) {
            GraphLayoutService.getInstance().performLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.g.get();
    }

    public final void queueUpdate() {
        if (this.g.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                long l2 = r ^ 0x34E2201022BAL;
                final Cursor cursor = this.e.getJComponent().getCursor();
                this.e.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
                this.i.queue(new Update("Update"){

                    public void run() {
                        GraphBuilderImpl.this.updateGraph(true);
                        GraphBuilderImpl.this.e.getJComponent().setCursor(cursor);
                        GraphBuilderImpl.this.g.set(false);
                    }
                });
            });
        }
    }

    @NotNull
    public GraphDataModel<N, E> getGraphDataModel() {
        GraphDataModel<N, E> graphDataModel = this.k;
        if (graphDataModel == null) {
            GraphBuilderImpl.a(20);
        }
        return graphDataModel;
    }

    @NotNull
    public String getNodeName(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.a(21);
        }
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.a(22);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(@Nullable Node node) {
        return node != null ? (N)GraphImplUtil.getNodeObject(this.getDataMaps(), node) : null;
    }

    @Nullable
    public E getEdgeObject(@Nullable Edge edge) {
        return edge != null ? (E)GraphImplUtil.getEdgeObject(this.getDataMaps(), edge) : null;
    }

    protected void updateDataMapsFromDataModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        for (Object e10 : graphDataModel.getNodes()) {
            this.addNode(graphDataModel.getNodeName(e10), e10);
        }
        for (Object e10 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10);
        }
    }

    protected void updateGroups() {
        NodeList nodeList;
        Object object3;
        Node node;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node = this.getNode(object22);
                if (node == null || this.getHierarchyManager().isRootGraph(node.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node2 : graph.getNodeArray()) {
                        if (this.isGroupNode(node2)) continue;
                        nodeList.add((Object)node2);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.d, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node)) {
                arrayList.add(node);
            }
            nodeList = graphManager.createNodeList();
            for (Object e10 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e10));
            }
            if (nodeList.size() <= 0 || !this.d.isGroupNode(node)) continue;
            this.d.groupSubgraph(nodeList, node);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.d.closeGroup((Node)nodesGroup2);
                node = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node).setGroupClosed(true);
                object3 = this.d.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.f();
            }
            catch (Throwable throwable) {
                l.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.isGroupNode((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    protected boolean isGroupNode(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.a(23);
        }
        return this.d.isFolderNode(node) || this.d.isGroupNode(node);
    }

    public void addNode(N nodeObject) {
        String string = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(string, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.a(24);
        }
        this.addNode(name, nodeObject, nodeObject);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void addNode(@NotNull String string, N n2, Object ... objectArray) {
        void nodeObject;
        void equalityObjects;
        Node node;
        void name;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (name == null) {
            GraphBuilderImpl.a(25);
        }
        if ((node = GraphImplUtil.getExistedNode(this.getDataMaps(), (String)name, (Object[])equalityObjects)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName(this.getDataMaps(), node, (String)name);
            }
        } else {
            node = GraphImplUtil.createNode((Graph)this.getGraph(), this.a(nodeObject), this.getDataMaps(), (String)name, (Object[])equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, nodeObject);
    }

    @Nullable
    private Graph a(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node)) {
                return this.getHierarchyManager().getInnerGraph(node);
            }
        }
        return null;
    }

    @NotNull
    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(26);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(27);
        }
        Edge edge = this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
        if (edge == null) {
            GraphBuilderImpl.a(28);
        }
        return edge;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public Edge addEdge(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10) {
        void edgeObject;
        void name;
        void nodeObject2;
        void nodeObject1;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(29);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(30);
        }
        if (name == null) {
            GraphBuilderImpl.a(31);
        }
        return this.a(nodeObject1, nodeObject2, (String)name, edgeObject, edgeObject);
    }

    @NotNull
    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(32);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(33);
        }
        if (string == null) {
            GraphBuilderImpl.a(34);
        }
        Node node = this.a(n2);
        Node node2 = this.a(n3);
        return this.a(node, node2, string, e10, objectArray);
    }

    @NotNull
    private Edge a(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e10, Object ... objectArray) {
        Edge edge;
        if (node == null) {
            GraphBuilderImpl.a(35);
        }
        if (node2 == null) {
            GraphBuilderImpl.a(36);
        }
        if (string == null) {
            GraphBuilderImpl.a(37);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getGraph(), this.getDataMaps(), node, node2, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphBuilderImpl.a(38);
        }
        return edge2;
    }

    @NotNull
    private Node a(N n2) {
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            l.error("null node for " + n2 + " in " + this.k);
        }
        Node node2 = node;
        if (node2 == null) {
            GraphBuilderImpl.a(39);
        }
        return node2;
    }

    public void dispose() {
        if (this.f.compareAndSet(false, true)) {
            this.i.cancelAllUpdates();
            this.h.dispose();
            GraphSelectionService.getInstance().onGraphBuilderDispose((GraphBuilder)this);
        }
    }

    @Nullable
    public String getNodeName(@Nullable N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(@Nullable E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(@Nullable N nodeObject) {
        return nodeObject == null ? null : GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(@Nullable E edgeObject) {
        return edgeObject != null ? GraphImplUtil.getEdge(this.getDataMaps(), edgeObject) : null;
    }

    public boolean isNodeWasCreated(@Nullable Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasCreated(node);
    }

    public boolean isEdgeWasCreated(@Nullable Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(@Nullable Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasUpdated(node);
    }

    public boolean isEdgeWasUpdated(@Nullable Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    @RequiresReadLock
    @NotNull
    public final Graph2D getGraph() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph2D graph2D = this.c;
        if (graph2D == null) {
            GraphBuilderImpl.a(40);
        }
        return graph2D;
    }

    @RequiresReadLock
    @NotNull
    public Graph2DView getView() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph2DView graph2DView = this.e;
        if (graph2DView == null) {
            GraphBuilderImpl.a(41);
        }
        return graph2DView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.q;
        if (project == null) {
            GraphBuilderImpl.a(42);
        }
        return project;
    }

    @NotNull
    public GraphUpdateModel getGraphUpdateModel() {
        GraphUpdateModel graphUpdateModel = this.j;
        if (graphUpdateModel == null) {
            GraphBuilderImpl.a(43);
        }
        return graphUpdateModel;
    }

    @NotNull
    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        GraphPresentationModel<N, E> graphPresentationModel = this.m;
        if (graphPresentationModel == null) {
            GraphBuilderImpl.a(44);
        }
        return graphPresentationModel;
    }

    @RequiresReadLock
    public double getZoom() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setZoom(double d10, boolean bl2) {
        void zoom;
        ApplicationManager.getApplication().assertIsDispatchThread();
        double d11 = MathUtil.clamp((double)zoom, (double)0.1, (double)20.0);
        Graph2DView graph2DView = this.getView();
        double d12 = graph2DView.getZoom();
        if (Math.abs(d11 - d12) > 0.01) {
            void fireEvents;
            if (fireEvents != false) {
                this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
            }
            graph2DView.setZoom(d11);
            graph2DView.updateView();
            if (fireEvents != false) {
                this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void fitContent(boolean bl2) {
        void animated;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        GraphAnimationService.getInstance().fitContent(graph2DView, (boolean)animated);
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.a(45);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.n;
        synchronized (eventDispatcher) {
            if (before) {
                ((GraphBuilderListener)this.n.getMulticaster()).beforeActionPerformed((GraphBuilder)this, event);
            } else {
                ((GraphBuilderListener)this.n.getMulticaster()).actionPerformed((GraphBuilder)this, event);
            }
        }
    }

    private boolean a() {
        return this.a.get();
    }

    private void d() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), string -> {
            if (DeleteProvider.DELETE_PROVIDER.is(string)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.d;
        if (hierarchyManager == null) {
            GraphBuilderImpl.a(46);
        }
        return hierarchyManager;
    }

    public void addCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.a(47);
        }
        this.p.add(updater);
    }

    @NotNull
    public EditMode getEditMode() {
        EditMode editMode = (EditMode)ReadAction.compute(() -> this.b);
        if (editMode == null) {
            GraphBuilderImpl.a(48);
        }
        return editMode;
    }

    @NotNull
    public ViewMode getActiveMode() {
        assert (this.o != null);
        ViewMode viewMode = this.o;
        if (viewMode == null) {
            GraphBuilderImpl.a(49);
        }
        return viewMode;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setActiveMode(@NotNull ViewMode viewMode) {
        void activeMode;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (activeMode == null) {
            GraphBuilderImpl.a(50);
        }
        this.o = activeMode;
    }

    @RequiresReadLock
    public boolean isCellEditing() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        assert (this.b != null);
        ViewMode viewMode = this.b.getEditNodeMode();
        return viewMode instanceof CellEditorMode && ((CellEditorMode)viewMode).isCellEditing();
    }

    @NotNull
    public GraphDataMaps<N, E> getDataMaps() {
        GraphDataMaps<N, E> graphDataMaps = this.h;
        if (graphDataMaps == null) {
            GraphBuilderImpl.a(51);
        }
        return graphDataMaps;
    }

    @RequiresReadLock
    @NotNull
    public Collection<N> getNodeObjects() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getNodeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.a(52);
        }
        return collection;
    }

    @RequiresReadLock
    @NotNull
    public Collection<E> getEdgeObjects() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getEdgeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.a(53);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean removeNode(@Nullable N n2) {
        void n3;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Node node = this.getNode(n3);
        if (node != null) {
            node.getGraph().removeNode(node);
            this.getDataMaps().removeNode(node);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean removeEdge(@Nullable E e10) {
        void e11;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Edge edge = this.getEdge(e11);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphBuilderListener(@NotNull GraphBuilderListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            GraphBuilderImpl.a(54);
        }
        if (parent == null) {
            GraphBuilderImpl.a(55);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.n;
        synchronized (eventDispatcher) {
            this.n.addListener((EventListener)listener, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphBuilderListener(@NotNull GraphBuilderListener listener) {
        if (listener == null) {
            GraphBuilderImpl.a(56);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.n;
        synchronized (eventDispatcher) {
            this.n.removeListener((EventListener)listener);
        }
    }

    @RequiresEdt
    private static void a(@NotNull Graph2DView graph2DView) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (graph2DView == null) {
            GraphBuilderImpl.a(57);
        }
        Graph2DViewActions graph2DViewActions = GraphManager.getGraphManager().createGraph2DViewActions(graph2DView);
        graph2DViewActions.install(graph2DView, 1);
    }

    @RequiresEdt
    private static void b(@NotNull Graph2DView graph2DView) {
        long l2 = r ^ 0x5A830F940609L;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (graph2DView == null) {
            GraphBuilderImpl.a(58);
        }
        graph2DView.setAntialiasedPainting(Registry.is((String)"diagrams.rendering.antialiasing"));
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(35.0);
        graph2DView.setGridColor((Color)JBColor.LIGHT_GRAY);
        graph2DView.setGridType(View2DConstants.GRID_POINTS);
    }

    static {
        r = la.a(5756876904129707037L, -6069992248413484646L, MethodHandles.lookup().lookupClass()).a(226041334330245L);
        l = Logger.getInstance(GraphBuilderImpl.class);
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x5F4581A9EA20L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 7: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataModel";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphPresentationModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdgeRealizer";
                break;
            }
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultEditMode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphDataModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addEdge";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNode";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphUpdateModel";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMaps";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjects";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedEdges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedNodes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeRealizer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeRealizer";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeLabels";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isGroupNode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addGraphBuilderListener";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "removeGraphBuilderListener";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setupDefaultKeyBindingsForYFilesPredefinedActions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultViewSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

