/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import b.h.la;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphSvgExporter;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.View;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ExportToFileAction
extends AbstractGraphAction {
    @NotNull
    private static final Logger b;
    @NotNull
    private static final String e = "png";
    private static final String @NotNull [] a;
    private static final double c = 2.0;
    private static final double d = 2.0;
    private static final long f;

    public void actionPerformed(@NotNull AnActionEvent e10, @NotNull Graph2D __) {
        GraphBuilder graphBuilder;
        long l2 = f ^ 0x21D1DF36604EL;
        if (e10 == null) {
            ExportToFileAction.a(0);
        }
        if (__ == null) {
            ExportToFileAction.a(1);
        }
        if ((graphBuilder = this.getBuilder(e10)) == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)e10.getData(CommonDataKeys.VIRTUAL_FILE);
        String string = (String)ObjectUtils.notNull((Object)e10.getPresentation().getText(), (Object)GraphBundle.message((String)"dialog.title.export", (Object[])new Object[0]));
        File file = ExportToFileAction.a(graphBuilder.getProject(), virtualFile != null ? virtualFile.getParent() : null, virtualFile != null ? FileUtilRt.getNameWithoutExtension((String)virtualFile.getPresentableName()) : "diagram", string, StringUtil.notNullize((String)e10.getPresentation().getDescription()));
        if (file == null) {
            return;
        }
        ExportToFileAction.exportToFile(graphBuilder, string, file);
    }

    static void exportToFile(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @NotNull File resultImageFile) {
        if (builder == null) {
            ExportToFileAction.a(2);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.a(3);
        }
        if (resultImageFile == null) {
            ExportToFileAction.a(4);
        }
        ExportToFileAction.a(builder, exportDialogTitle, (ExportContext exportContext) -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ReadAction.run(() -> ExportToFileAction.b(builder, exportContext, resultImageFile));
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(resultImageFile));
        }, exportDialogTitle, false, builder.getProject()));
    }

    @NotNull
    static Image exportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle) {
        if (builder == null) {
            ExportToFileAction.a(5);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.a(6);
        }
        return ExportToFileAction.doExportToImage(builder, exportDialogTitle, null);
    }

    @NotNull
    static Image exportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @NotNull Rectangle area) {
        if (builder == null) {
            ExportToFileAction.a(7);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.a(8);
        }
        if (area == null) {
            ExportToFileAction.a(9);
        }
        return ExportToFileAction.doExportToImage(builder, exportDialogTitle, area);
    }

    @NotNull
    static Image doExportToImage(@NotNull GraphBuilder<?, ?> builder, @NotNull @Nls String exportDialogTitle, @Nullable Rectangle area) {
        if (builder == null) {
            ExportToFileAction.a(10);
        }
        if (exportDialogTitle == null) {
            ExportToFileAction.a(11);
        }
        Ref ref = Ref.create();
        WriteAction.runAndWait(() -> ExportToFileAction.a(builder, exportDialogTitle, (ExportContext exportContext) -> ref.set((Object)ExportToFileAction.a(exportContext.c, area))));
        Image image = (Image)ref.get();
        if (image == null) {
            ExportToFileAction.a(12);
        }
        return image;
    }

    @Nullable
    private static File a(@NotNull Project project, @Nullable VirtualFile virtualFile, @NotNull String string, @NotNull @NlsContexts.DialogTitle String string2, @NotNull @NlsContexts.Label String string3) {
        JFrame jFrame;
        if (project == null) {
            ExportToFileAction.a(13);
        }
        if (string == null) {
            ExportToFileAction.a(14);
        }
        if (string2 == null) {
            ExportToFileAction.a(15);
        }
        if (string3 == null) {
            ExportToFileAction.a(16);
        }
        if ((jFrame = WindowManager.getInstance().getFrame(project)) == null) {
            return null;
        }
        VirtualFileWrapper virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(string2, string3, a), (Component)jFrame).save(virtualFile, string);
        if (virtualFileWrapper == null) {
            return null;
        }
        File file = virtualFileWrapper.getFile();
        if (!ArrayUtil.contains((String)StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)file.getName())), (String[])a)) {
            file = new File(file.getPath() + ".png");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull @Nls String string, @NotNull Consumer<ExportContext> consumer) {
        if (graphBuilder == null) {
            ExportToFileAction.a(17);
        }
        if (string == null) {
            ExportToFileAction.a(18);
        }
        if (consumer == null) {
            ExportToFileAction.a(19);
        }
        ExportContext exportContext = ExportToFileAction.a(graphBuilder);
        try {
            consumer.accept(exportContext);
        }
        catch (Exception exception) {
            b.error((Throwable)exception);
            Messages.showErrorDialog((Project)graphBuilder.getProject(), (String)exception.getMessage(), (String)string);
        }
        finally {
            ExportToFileAction.a(graphBuilder, exportContext);
        }
    }

    @NotNull
    private static ExportContext a(@NotNull GraphBuilder<?, ?> graphBuilder) {
        Graph2DView graph2DView;
        ZoomableViewport zoomableViewport;
        if (graphBuilder == null) {
            ExportToFileAction.a(20);
        }
        if ((zoomableViewport = (ZoomableViewport)UIUtil.uiParents((Component)(graph2DView = graphBuilder.getView()).getComponent(), (boolean)false).filter(ZoomableViewport.class).first()) != null) {
            zoomableViewport.magnificationStarted(new Point(0, 0));
            zoomableViewport.magnify(0.0);
        }
        GraphExportService.getInstance().setExportMode(true);
        return new ExportContext(graphBuilder.getView(), ExportToFileAction.a(graphBuilder), zoomableViewport);
    }

    private static void b(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull ExportContext exportContext, @NotNull File file) {
        long l2 = f ^ 0x61EC736FA500L;
        if (graphBuilder == null) {
            ExportToFileAction.a(21);
        }
        if (exportContext == null) {
            ExportToFileAction.a(22);
        }
        if (file == null) {
            ExportToFileAction.a(23);
        }
        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
        String string = FileUtilRt.getExtension((String)file.getName());
        try {
            if (StringUtil.startsWithIgnoreCase((String)string, (String)"svg")) {
                Graph2D graph2D = graphBuilder.getGraph();
                graph2D.setCurrentView((View)exportContext.c);
                GraphSvgExporter.getGraphSvgExporter().exportToSvg(graph2D, file.getPath(), string);
            } else {
                BufferedImage bufferedImage = ExportToFileAction.a(exportContext.c, null);
                ImageIO.write((RenderedImage)bufferedImage, FileUtilRt.getExtension((String)file.getName()), file);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        RevealFileAction.openFile((File)file);
    }

    private static void a(@NotNull GraphBuilder<?, ?> graphBuilder, @NotNull ExportContext exportContext) {
        if (graphBuilder == null) {
            ExportToFileAction.a(24);
        }
        if (exportContext == null) {
            ExportToFileAction.a(25);
        }
        Graph2D graph2D = graphBuilder.getGraph();
        graph2D.removeView((View)exportContext.c);
        graph2D.setCurrentView((View)exportContext.b);
        GraphExportService.getInstance().setExportMode(false);
        if (exportContext.a != null) {
            exportContext.a.magnificationFinished(0.0);
        }
    }

    @NotNull
    private static Graph2DView a(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            ExportToFileAction.a(26);
        }
        Graph2D graph2D = graphBuilder.getGraph();
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView(graph2D);
        graph2DView.setZoom(4.0);
        graph2DView.setAntialiasedPainting(true);
        graph2DView.setPaintDetailThreshold(0.0);
        GraphViewUtil.updateWorldRect((Graph2DView)graph2DView);
        Rectangle rectangle = graph2DView.getWorldRect();
        graph2DView.setViewPoint2D(rectangle.getMinX(), rectangle.getMinY());
        Dimension dimension = new Dimension(graph2DView.toViewCoordX(rectangle.getMaxX()), graph2DView.toViewCoordY(rectangle.getMaxY()));
        graph2DView.getCanvasComponent().setSize(dimension);
        graph2DView.getCanvasComponent().setPreferredSize(dimension);
        ((DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer()).setColor(graph2D.getCurrentView().getComponent().getBackground());
        ObjectUtils.consumeIfCast((Object)graphBuilder.getGraphPresentationModel(), BasicGraphPresentationModel.class, basicGraphPresentationModel -> basicGraphPresentationModel.setupBridgesFor(graph2DView.getGraph2DRenderer()));
        Graph2DView graph2DView2 = graph2DView;
        if (graph2DView2 == null) {
            ExportToFileAction.a(27);
        }
        return graph2DView2;
    }

    @NotNull
    private static BufferedImage a(@NotNull Graph2DView graph2DView, @Nullable Rectangle rectangle) {
        BufferedImage bufferedImage;
        long l2 = f ^ 0x7ABE446B1997L;
        if (graph2DView == null) {
            ExportToFileAction.a(28);
        }
        if (rectangle == null) {
            rectangle = graph2DView.getWorldRect();
        }
        try {
            bufferedImage = new BufferedImage((int)(2.0 * (double)rectangle.width), (int)(2.0 * (double)rectangle.height), 1);
        }
        catch (NegativeArraySizeException | OutOfMemoryError throwable) {
            throw new IllegalArgumentException(GraphBundle.message((String)"graph.ExportToFileAction.image.is.too.large", (Object[])new Object[]{rectangle.width, rectangle.height}), throwable);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphicsUtil.setupAAPainting((Graphics)graphics2D);
        graphics2D.setBackground(((DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer()).getColor());
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.scale(0.5, 0.5);
        graphics2D.translate(-graph2DView.toViewCoordX((double)rectangle.x), -graph2DView.toViewCoordY((double)rectangle.y));
        graph2DView.getCanvasComponent().paint(graphics2D);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ExportToFileAction.a(29);
        }
        return bufferedImage2;
    }

    static {
        f = la.a(5215937283717579637L, -1813860664739737425L, MethodHandles.lookup().lookupClass()).a(201335196273130L);
        long l2 = f ^ 0x3B34A93E5418L;
        b = Logger.getInstance(ExportToFileAction.class);
        a = new String[]{e, "jpg", "gif", "svg", "svgz"};
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x1CB6A713F499L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDialogTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultImageFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageFileName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDialogDescription";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doExport";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doExportToImage";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createExportView";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "paintToImage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportToFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportToImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doExportToImage";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "askUserToChooseFileToSaveInto";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupExportAndRun";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setUpBeforeExport";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doExportToFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tearDownAfterExport";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createExportView";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "paintToImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExportContext {
        @NotNull
        private final Graph2DView b;
        @NotNull
        private final Graph2DView c;
        @Nullable
        private final ZoomableViewport a;
        private static final long d = la.a(595207993275262380L, 7878646265929288344L, MethodHandles.lookup().lookupClass()).a(52508535326111L);

        private ExportContext(@NotNull Graph2DView oldView, @NotNull Graph2DView exportView, @Nullable ZoomableViewport zoomable) {
            if (oldView == null) {
                ExportContext.a(0);
            }
            if (exportView == null) {
                ExportContext.a(1);
            }
            this.b = oldView;
            this.c = exportView;
            this.a = zoomable;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = d ^ 0x53FD152D88C0L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exportView";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/graph/builder/actions/export/ExportToFileAction$ExportContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

