/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import b.h.la;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.UsagesEditSourceDescriptor;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import java.lang.invoke.MethodHandles;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeNode
extends BasicTreeNode {
    private RangeMarker c;
    private VirtualFile f;
    private final int g;
    private final DuplicatesPresentation d;
    private final PsiFragment e;
    private static final long i = la.a(5281932761838552683L, 7621817805985919564L, MethodHandles.lookup().lookupClass()).a(100930762751081L);

    public CodeNode(GroupNode parent, @NotNull PsiFragment fragment, @Nullable UsageInfo info, int index) {
        PsiElement psiElement;
        if (fragment == null) {
            CodeNode.b(0);
        }
        super(false, parent);
        this.e = fragment;
        this.d = parent.getPresentation();
        this.g = index;
        if (info != null && (psiElement = info.getElement()) != null) {
            PsiElement psiElement2;
            TextRange textRange = psiElement.getTextRange().cutOut((TextRange)info.getRangeInElement());
            this.f = psiElement.getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(this.f);
            int n2 = textRange.getStartOffset();
            int n3 = document.getLineNumber(n2);
            int n4 = document.getLineStartOffset(n3);
            PsiElement psiElement3 = psiElement.getContainingFile().findElementAt(n4);
            if (psiElement3 instanceof PsiWhiteSpace && (psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement3)) != null && psiElement2.getTextRange().getStartOffset() == n2) {
                n2 = n4;
            }
            this.c = document.createRangeMarker(n2, textRange.getEndOffset(), true);
        }
    }

    public PsiFragment getFragment() {
        return this.e;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return this.d;
    }

    @Override
    protected TreeNode[] getChildren() {
        return new TreeNode[0];
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public GroupNode getParent() {
        return (GroupNode)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Nullable
    public DocumentContent getDiffContentIfValid() {
        try {
            RangeMarker rangeMarker = this.getRangeMarker();
            Document document = rangeMarker.getDocument();
            TextRange textRange = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
            return DiffContentFactory.getInstance().createFragment(this.getProject(), document, textRange);
        }
        catch (InvalidatedException invalidatedException) {
            return null;
        }
    }

    public CellAppearanceEx getTitle(boolean selected) {
        CompositeAppearance compositeAppearance = null;
        try {
            CodeFragmentType codeFragmentType;
            DuplicatesPresentation duplicatesPresentation = this.getPresentation();
            if (duplicatesPresentation != null && (codeFragmentType = duplicatesPresentation.getType(this)) != null) {
                compositeAppearance = codeFragmentType.getTitle(selected);
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        if (compositeAppearance == null) {
            compositeAppearance = CodeNode.invalidTitle();
        }
        compositeAppearance.getBeginning().addText("#" + this.g + " ", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        return compositeAppearance;
    }

    public VirtualFile getVirtualFile() throws InvalidatedException {
        if (this.f == null || !this.f.isValid()) {
            throw new InvalidatedException();
        }
        return this.f;
    }

    public boolean isValid() {
        return this.c != null && this.c.isValid();
    }

    public boolean isRightInDiff() {
        return Comparing.equal((Object)this.getModel().getRight(), (Object)this);
    }

    public boolean isLeftInDiff() {
        return Comparing.equal((Object)this.getModel().getLeft(), (Object)this);
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptorIfValid() {
        try {
            return new UsagesEditSourceDescriptor(this.getProject(), this.getVirtualFile(), this.getTextRange(), false);
        }
        catch (InvalidatedException invalidatedException) {
            return null;
        }
    }

    public RangeMarker getRangeMarker() throws InvalidatedException {
        if (this.c == null || !this.c.isValid()) {
            throw new InvalidatedException();
        }
        return this.c;
    }

    public TextRange getTextRange() throws InvalidatedException {
        RangeMarker rangeMarker = this.getRangeMarker();
        return TextRange.create((Segment)rangeMarker);
    }

    public static CompositeAppearance invalidTitle() {
        long l2 = i ^ 0x4CA26CF1EBCL;
        return CompositeAppearance.single((String)DupLocatorBundle.message((String)"duplicate.location.invalid", (Object[])new Object[0]), (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getIndex() {
        return this.g;
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = i ^ 0x5499740100E1L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/dupLocator/resultUI/CodeNode", "<init>"));
    }
}

