/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SideBorder;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    static final String TOOL_WINDOW_PROPERTY_PREFIX = "ATTACHED_TOOL_WINDOW.";
    static final String TOOL_WINDOW_TOOLBAR_PLACE = "TOOL_WINDOW_TOOLBAR";
    static final String LABEL_HEADER = "LABEL";
    static final String SEARCH_HEADER = "SEARCH";
    private final WorkBench<T> myWorkBench;
    private final ToolWindowDefinition<T> myDefinition;
    private final PropertiesComponent myPropertiesComponent;
    private final SideModel<T> myModel;
    private final JPanel myPanel;
    private final List<UpdatableActionButton> myActionButtons;
    private final AbstractButton myMinimizedButton;
    private final MySearchField mySearchField;
    private final ActionButton mySearchActionButton;
    private ButtonDragListener<T> myDragListener;
    @Nullable
    private ToolContent<T> myContent;
    private boolean myAutoHideOpen;
    private int myToolOrder;

    AttachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ButtonDragListener<T> dragListener, @NotNull WorkBench<T> workBench, @NotNull SideModel<T> model2, boolean minimizedByDefault) {
        if (definition == null) {
            AttachedToolWindow.$$$reportNull$$$0(0);
        }
        if (dragListener == null) {
            AttachedToolWindow.$$$reportNull$$$0(1);
        }
        if (workBench == null) {
            AttachedToolWindow.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            AttachedToolWindow.$$$reportNull$$$0(3);
        }
        this.myWorkBench = workBench;
        this.myDefinition = definition;
        this.myDragListener = dragListener;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myModel = model2;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myActionButtons = new ArrayList<UpdatableActionButton>(4);
        this.myMinimizedButton = new MinimizedButton(definition.getTitle(), definition.getIcon(), this);
        this.mySearchField = new MySearchField(TOOL_WINDOW_PROPERTY_PREFIX + workBench.getName() + ".TEXT_SEARCH_HISTORY");
        this.mySearchActionButton = this.createActionButton((AnAction)new SearchAction(), this.myDefinition.getButtonSize());
        this.setDefaultProperty(PropertyType.LEFT, definition.getSide().isLeft());
        this.setDefaultProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        this.setDefaultProperty(PropertyType.AUTO_HIDE, definition.getAutoHide().isAutoHide());
        this.setDefaultProperty(PropertyType.MINIMIZED, minimizedByDefault);
        this.updateContent();
        DumbService.getInstance((Project)model2.getProject()).smartInvokeLater(this::updateActions);
        AnAction globalFindAction = ActionManager.getInstance().getAction("Find");
        if (globalFindAction != null) {
            new FindAction().registerCustomShortcutSet(globalFindAction.getShortcutSet(), this.myPanel, this);
        }
    }

    public void dispose() {
        if (this.myContent != null) {
            this.myContent = null;
            this.myDragListener = null;
            this.myPanel.removeAll();
        }
    }

    @NotNull
    public String getToolName() {
        String string = this.myDefinition.getName();
        if (string == null) {
            AttachedToolWindow.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getToolOrder() {
        return this.myToolOrder;
    }

    public void setToolOrder(int order) {
        this.myToolOrder = order;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public AbstractButton getMinimizedButton() {
        AbstractButton abstractButton = this.myMinimizedButton;
        if (abstractButton == null) {
            AttachedToolWindow.$$$reportNull$$$0(6);
        }
        return abstractButton;
    }

    @Nullable
    public T getContext() {
        return this.myModel.getContext();
    }

    public ToolWindowDefinition<T> getDefinition() {
        return this.myDefinition;
    }

    public boolean isMinimized() {
        return this.getProperty(PropertyType.MINIMIZED);
    }

    public void setMinimized(boolean value) {
        this.setProperty(PropertyType.MINIMIZED, value);
    }

    public boolean isLeft() {
        return this.getProperty(PropertyType.LEFT);
    }

    public void setLeft(boolean value) {
        this.setProperty(PropertyType.LEFT, value);
    }

    public boolean isSplit() {
        return this.getProperty(PropertyType.SPLIT);
    }

    public void setSplit(boolean value) {
        this.setProperty(PropertyType.SPLIT, value);
    }

    public boolean isAutoHide() {
        return this.getProperty(PropertyType.AUTO_HIDE);
    }

    public void setAutoHide(boolean value) {
        this.setProperty(PropertyType.AUTO_HIDE, value);
    }

    public boolean isFloating() {
        return this.getProperty(PropertyType.FLOATING);
    }

    public void setFloating(boolean value) {
        this.setProperty(PropertyType.FLOATING, value);
    }

    public boolean isDetached() {
        return this.getProperty(PropertyType.DETACHED);
    }

    public void setDetached(boolean value) {
        this.setProperty(PropertyType.DETACHED, value);
    }

    public boolean getProperty(@NotNull PropertyType property) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(7);
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            return !this.myAutoHideOpen;
        }
        return this.getLayoutProperty(Layout.CURRENT, property);
    }

    public void setProperty(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(8);
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            this.myAutoHideOpen = !value;
        } else {
            this.setLayoutProperty(Layout.CURRENT, property, value);
        }
        if (this.myMinimizedButton != null) {
            this.myMinimizedButton.setSelected(!this.isMinimized());
        }
    }

    private boolean getLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(9);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(10);
        }
        return this.myPropertiesComponent.getBoolean(this.getPropertyName(layout, property));
    }

    private void setLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property, boolean value) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(11);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(12);
        }
        this.myPropertiesComponent.setValue(this.getPropertyName(layout, property), value);
    }

    public void setDefaultProperty(@NotNull PropertyType property, boolean defaultValue) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(13);
        }
        if (!this.myPropertiesComponent.isValueSet(this.getPropertyName(Layout.DEFAULT, property))) {
            this.myPropertiesComponent.setValue(this.getPropertyName(Layout.DEFAULT, property), defaultValue, !defaultValue);
            this.setLayoutProperty(Layout.CURRENT, property, defaultValue);
        }
    }

    private String getPropertyName(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(14);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(15);
        }
        String context = this.myWorkBench.getContext();
        return String.format("%s%s%s.%s.%s%s%s", TOOL_WINDOW_PROPERTY_PREFIX, layout.getPrefix(), this.myWorkBench.getName(), this.myDefinition.getName(), context, StringUtil.isEmpty((String)context) ? "" : ".", property.name());
    }

    public void setPropertyAndUpdate(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(16);
        }
        this.setProperty(property, value);
        if (property == PropertyType.FLOATING && value) {
            property = PropertyType.DETACHED;
            this.setProperty(property, true);
        }
        this.updateContent();
        this.updateActions();
        this.myModel.update(this, property);
        if (property == PropertyType.MINIMIZED && !value && this.myContent != null) {
            this.myContent.getFocusedComponent().requestFocus();
        }
    }

    public void storeDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setLayoutProperty(Layout.DEFAULT, property, this.getLayoutProperty(Layout.CURRENT, property));
        }
    }

    public void restoreDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setProperty(property, this.getLayoutProperty(Layout.DEFAULT, property));
        }
        this.updateContent();
        this.updateActions();
        this.myModel.update(this, PropertyType.DETACHED);
    }

    public void setContext(T context) {
        if (this.myContent != null) {
            this.myContent.setToolContext(context);
        }
    }

    @VisibleForTesting
    public SearchTextField getSearchField() {
        return this.mySearchField;
    }

    @VisibleForTesting
    @Nullable
    ToolContent<T> getContent() {
        return this.myContent;
    }

    private void updateContent() {
        if (this.isDetached() && this.myContent != null) {
            this.myPanel.removeAll();
            this.myContent.setToolContext(null);
            Disposer.dispose(this.myContent);
            this.myContent = null;
        } else if (!this.isDetached() && this.myContent == null) {
            this.myContent = this.myDefinition.getFactory().apply(this);
            assert (this.myContent != null);
            this.myContent.setToolContext(this.myModel.getContext());
            this.myContent.registerCallbacks(this);
            this.myPanel.add((Component)this.createHeader(this.myContent.supportsFiltering(), this.myContent.getAdditionalActions()), "North");
            this.myPanel.add((Component)this.myContent.getComponent(), "Center");
        }
        this.myPanel.putClientProperty("com.android.tools.adtui.workbench.TOOL_CONTENT", this.myContent);
    }

    @Override
    public void restore() {
        if (!this.isDetached() && this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, false);
        }
    }

    @Override
    public void autoHide() {
        if (!this.isDetached() && this.isAutoHide() && !this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private JComponent createHeader(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        if (additionalActions == null) {
            AttachedToolWindow.$$$reportNull$$$0(17);
        }
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)AttachedToolWindow.createTitlePanel(this.myDefinition.getTitle(), includeSearchButton, this.mySearchField), "Center");
        header.add((Component)this.createActionPanel(includeSearchButton, additionalActions), "East");
        header.setBorder((Border)new SideBorder(JBColor.border(), 8));
        JPanel jPanel = header;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createTitlePanel(@NotNull String title, boolean includeSearchField, @NotNull SearchTextField searchField) {
        if (title == null) {
            AttachedToolWindow.$$$reportNull$$$0(19);
        }
        if (searchField == null) {
            AttachedToolWindow.$$$reportNull$$$0(20);
        }
        CardLayout layout = new CardLayout();
        JPanel titlePanel = new JPanel(layout);
        JBLabel titleLabel = new JBLabel(title){

            public void updateUI() {
                super.updateUI();
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
        };
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titlePanel.add((Component)titleLabel, LABEL_HEADER);
        if (includeSearchField) {
            searchField.setPreferredSize(new Dimension(searchField.getPreferredSize().width, titlePanel.getPreferredSize().height));
            titlePanel.add((Component)searchField, SEARCH_HEADER);
        }
        layout.show(titlePanel, LABEL_HEADER);
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(21);
        }
        return jPanel;
    }

    private void showSearchField(boolean show) {
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        Container parent = this.mySearchField.getParent();
        CardLayout layout = (CardLayout)parent.getLayout();
        if (show) {
            layout.show(parent, SEARCH_HEADER);
            this.mySearchField.requestFocus();
        } else {
            layout.show(parent, LABEL_HEADER);
        }
        this.mySearchActionButton.setVisible(!show);
    }

    @Override
    public void startFiltering(@NotNull String initialSearchString) {
        if (initialSearchString == null) {
            AttachedToolWindow.$$$reportNull$$$0(22);
        }
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        this.mySearchField.setText(initialSearchString);
        this.showSearchField(true);
    }

    @Override
    public void stopFiltering() {
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        this.mySearchField.setText("");
        this.showSearchField(false);
    }

    @NotNull
    private JComponent createActionPanel(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        Dimension buttonSize;
        if (additionalActions == null) {
            AttachedToolWindow.$$$reportNull$$$0(23);
        }
        int border = (buttonSize = this.myDefinition.getButtonSize()).equals(ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE) ? 4 : 2;
        JPanel actionPanel = new JPanel(new FlowLayout(1, 0, 0));
        actionPanel.setOpaque(false);
        actionPanel.setBorder((Border)JBUI.Borders.empty((int)border, (int)0));
        if (includeSearchButton) {
            actionPanel.add((Component)this.mySearchActionButton);
            this.mySearchActionButton.setVisible(true);
        }
        if (!additionalActions.isEmpty()) {
            additionalActions.forEach(action -> actionPanel.add((Component)this.createActionButton((AnAction)action, buttonSize)));
            actionPanel.add(new JLabel(AllIcons.General.Divider));
        }
        actionPanel.add((Component)this.createActionButton((AnAction)new GearAction(), buttonSize));
        actionPanel.add((Component)this.createActionButton((AnAction)new HideAction(), buttonSize));
        JPanel jPanel = actionPanel;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(24);
        }
        return jPanel;
    }

    @NotNull
    private ActionButton createActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
        if (action == null) {
            AttachedToolWindow.$$$reportNull$$$0(25);
        }
        if (buttonSize == null) {
            AttachedToolWindow.$$$reportNull$$$0(26);
        }
        UpdatableActionButton button2 = new UpdatableActionButton(action, buttonSize);
        button2.setFocusable(true);
        this.myActionButtons.add(button2);
        UpdatableActionButton updatableActionButton = button2;
        if (updatableActionButton == null) {
            AttachedToolWindow.$$$reportNull$$$0(27);
        }
        return updatableActionButton;
    }

    @VisibleForTesting
    public void updateActions() {
        this.myActionButtons.forEach(ActionButton::update);
    }

    private void showGearPopup(@NotNull Component component, int x, int y) {
        if (component == null) {
            AttachedToolWindow.$$$reportNull$$$0(28);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearPopupActions(group);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group);
        popupMenu.getComponent().show(component, x, y);
    }

    private void addGearPopupActions(@NotNull DefaultActionGroup group) {
        List<AnAction> myExtraGearActions;
        if (group == null) {
            AttachedToolWindow.$$$reportNull$$$0(29);
        }
        if (this.myContent != null && !(myExtraGearActions = this.myContent.getGearActions()).isEmpty()) {
            group.addAll(myExtraGearActions);
            group.addSeparator();
        }
        DefaultActionGroup attachedSide = DefaultActionGroup.createPopupGroup(() -> "Attached Side");
        attachedSide.add((AnAction)new TogglePropertyTypeDumbAction(PropertyType.LEFT, "Left"));
        attachedSide.add((AnAction)new ToggleOppositePropertyTypeDumbAction(PropertyType.LEFT, "Right"));
        attachedSide.add((AnAction)new SwapAction());
        if (this.myDefinition.isFloatingAllowed()) {
            attachedSide.add((AnAction)new TogglePropertyTypeDumbAction(PropertyType.DETACHED, "None"));
        }
        group.add((AnAction)attachedSide);
        ActionManager manager = ActionManager.getInstance();
        if (this.myDefinition.isAutoHideAllowed()) {
            group.add((AnAction)new ToggleOppositePropertyTypeDumbAction(PropertyType.AUTO_HIDE, manager.getAction("ToggleDockMode")));
        }
        if (this.myDefinition.isFloatingAllowed()) {
            group.add((AnAction)new TogglePropertyTypeDumbAction(PropertyType.FLOATING, manager.getAction("ToggleFloatingMode")));
        }
        if (this.myDefinition.isSplitModeChangesAllowed()) {
            group.add((AnAction)new TogglePropertyTypeDumbAction(PropertyType.SPLIT, manager.getAction("ToggleSideMode")));
        }
    }

    @VisibleForTesting
    void fireButtonDragged(@NotNull DragEvent event) {
        if (event == null) {
            AttachedToolWindow.$$$reportNull$$$0(30);
        }
        this.myDragListener.buttonDragged(this, event);
    }

    @VisibleForTesting
    void fireButtonDropped(@NotNull DragEvent event) {
        if (event == null) {
            AttachedToolWindow.$$$reportNull$$$0(31);
        }
        this.myDragListener.buttonDropped(this, event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workBench";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/AttachedToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalActions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchField";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSearchString";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttonSize";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimizedButton";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitlePanel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPanel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPropertyAndUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTitlePanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startFiltering";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createActionPanel";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showGearPopup";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addGearPopupActions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fireButtonDragged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fireButtonDropped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class FindAction
    extends DumbAwareAction {
        private FindAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                FindAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.showSearchField(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$FindAction", "actionPerformed"));
        }
    }

    private class MySearchField
    extends SearchTextField
    implements KeyListener {
        private Component myOldFocusComponent;

        private MySearchField(String propertyName) {
            if (propertyName == null) {
                MySearchField.$$$reportNull$$$0(0);
            }
            super(propertyName);
            this.addKeyboardListener(this);
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AttachedToolWindow.this.myContent != null) {
                        AttachedToolWindow.this.myContent.setFilter(MySearchField.this.getText().trim());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField$1", "textChanged"));
                }
            });
            this.getTextEditor().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MySearchField.this.myOldFocusComponent = event.getOppositeComponent();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField$2", "focusGained"));
                }
            });
        }

        public void removeNotify() {
            super.removeNotify();
            this.putClientProperty(AnAction.ACTIONS_KEY, null);
        }

        protected void onFocusLost() {
            Component focusedDescendant = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)((Object)this));
            if (focusedDescendant == null && this.getText().trim().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
            }
            this.myOldFocusComponent = null;
            super.onFocusLost();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(1);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyTyped(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(2);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyPressed(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
            if (event.getKeyCode() == 27 && this.getText().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
                if (this.myOldFocusComponent != null) {
                    this.myOldFocusComponent.requestFocus();
                } else if (AttachedToolWindow.this.myContent != null) {
                    AttachedToolWindow.this.myContent.getFocusedComponent().requestFocus();
                } else {
                    AttachedToolWindow.this.mySearchActionButton.requestFocus();
                }
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(3);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyReleased(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SwapAction
    extends DumbAwareAction {
        private SwapAction() {
            super("Swap");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                SwapAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.myModel.swap();
            AttachedToolWindow.this.updateActions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$SwapAction", "actionPerformed"));
        }
    }

    private class ToggleOppositePropertyTypeDumbAction
    extends TogglePropertyTypeDumbAction {
        private ToggleOppositePropertyTypeDumbAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(1);
            }
            super(property, text);
        }

        private ToggleOppositePropertyTypeDumbAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(2);
            }
            if (action == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(3);
            }
            super(property, action);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(4);
            }
            return !super.isSelected(event);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                ToggleOppositePropertyTypeDumbAction.$$$reportNull$$$0(5);
            }
            super.setSelected(event, !state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeDumbAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TogglePropertyTypeDumbAction
    extends DumbAwareToggleAction {
        private final PropertyType myProperty;

        private TogglePropertyTypeDumbAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(1);
            }
            super(text);
            this.myProperty = property;
        }

        private TogglePropertyTypeDumbAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(2);
            }
            if (action == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(3);
            }
            this.myProperty = property;
            this.copyFrom(action);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(4);
            }
            return AttachedToolWindow.this.getProperty(this.myProperty);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                TogglePropertyTypeDumbAction.$$$reportNull$$$0(5);
            }
            AttachedToolWindow.this.setPropertyAndUpdate(this.myProperty, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeDumbAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HideAction
    extends DumbAwareAction {
        private HideAction() {
            super(UIBundle.messagePointer((String)"tool.window.hide.action.name", (Object[])new Object[0]), AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$HideAction", "actionPerformed"));
        }
    }

    private class GearAction
    extends DumbAwareAction {
        private GearAction() {
            super("More Options", null, AllIcons.General.GearPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                GearAction.$$$reportNull$$$0(0);
            }
            int x = 0;
            int y = 0;
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            AttachedToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$GearAction", "actionPerformed"));
        }
    }

    private class SearchAction
    extends DumbAwareAction {
        private SearchAction() {
            super("Search");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Find);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                SearchAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.showSearchField(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$SearchAction", "actionPerformed"));
        }
    }

    private static class UpdatableActionButton
    extends ActionButton {
        private UpdatableActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
            if (action == null) {
                UpdatableActionButton.$$$reportNull$$$0(0);
            }
            if (buttonSize == null) {
                UpdatableActionButton.$$$reportNull$$$0(1);
            }
            super(action, action.getTemplatePresentation().clone(), AttachedToolWindow.TOOL_WINDOW_TOOLBAR_PLACE, buttonSize);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buttonSize";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$UpdatableActionButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MinimizedButton
    extends AnchoredButton {
        private final AttachedToolWindow<?> myToolWindow;
        private JLabel myDragImage;
        private Point myStartDragPosition;

        private MinimizedButton(@NotNull String title, @NotNull Icon icon, @NotNull AttachedToolWindow<?> toolWindow) {
            if (title == null) {
                MinimizedButton.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                MinimizedButton.$$$reportNull$$$0(1);
            }
            if (toolWindow == null) {
                MinimizedButton.$$$reportNull$$$0(2);
            }
            super(title, icon);
            this.myToolWindow = toolWindow;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setSelected(!toolWindow.isMinimized());
            this.setOpaque(false);
            this.setBackground(null);
            MouseInputAdapter listener = new MouseInputAdapter(){

                @Override
                public void mouseDragged(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.handleDragging(event);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.stopDragging(event);
                }

                @Override
                public void mouseClicked(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (event.getButton() <= 1) {
                        this.setSelected(false);
                        myToolWindow.setPropertyAndUpdate(PropertyType.MINIMIZED, !myToolWindow.isMinimized());
                    } else {
                        myToolWindow.showGearPopup((Component)((Object)this), event.getX(), event.getY());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseDragged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }

        public void updateUI() {
            this.setUI(StripeButtonUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public void paint(@NotNull Graphics graphics) {
            if (graphics == null) {
                MinimizedButton.$$$reportNull$$$0(3);
            }
            if (this.isDragging()) {
                return;
            }
            if (!this.myToolWindow.isLeft()) {
                super.paint(graphics);
                return;
            }
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(JBUI.scale((int)1), 0);
                super.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }

        public int getMnemonic2() {
            return 0;
        }

        public ToolWindowAnchor getAnchor() {
            return this.myToolWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        }

        private boolean isDragging() {
            return this.myDragImage != null;
        }

        private void handleDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(4);
            }
            if (!this.isDragging()) {
                this.startDragging(event);
            }
            this.myToolWindow.fireButtonDragged(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
        }

        private void stopDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(5);
            }
            if (this.isDragging()) {
                this.myToolWindow.fireButtonDropped(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
                this.myDragImage = null;
                this.myStartDragPosition = null;
            }
        }

        private void startDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(6);
            }
            BufferedImage image = ImageUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics graphics = image.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            this.myDragImage = new JBLabel((Icon)new JBImageIcon((Image)image));
            this.myStartDragPosition = event.getPoint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphics";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleDragging";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopDragging";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface ButtonDragListener<T> {
        public void buttonDragged(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);

        public void buttonDropped(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);
    }

    static class DragEvent {
        private final MouseEvent myMouseEvent;
        private final Component myDragImage;
        private final Point myDragPoint;

        DragEvent(@NotNull MouseEvent mouseEvent, @NotNull Component dragImage, @NotNull Point dragPoint) {
            if (mouseEvent == null) {
                DragEvent.$$$reportNull$$$0(0);
            }
            if (dragImage == null) {
                DragEvent.$$$reportNull$$$0(1);
            }
            if (dragPoint == null) {
                DragEvent.$$$reportNull$$$0(2);
            }
            this.myMouseEvent = mouseEvent;
            this.myDragImage = dragImage;
            this.myDragPoint = dragPoint;
        }

        @NotNull
        public Point getMousePoint() {
            Point point = this.myMouseEvent.getPoint();
            if (point == null) {
                DragEvent.$$$reportNull$$$0(3);
            }
            return point;
        }

        @NotNull
        public Component getDragImage() {
            Component component = this.myDragImage;
            if (component == null) {
                DragEvent.$$$reportNull$$$0(4);
            }
            return component;
        }

        @NotNull
        public Point getDragPoint() {
            Point point = this.myDragPoint;
            if (point == null) {
                DragEvent.$$$reportNull$$$0(5);
            }
            return point;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragImage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragPoint";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMousePoint";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragImage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum PropertyType {
        AUTO_HIDE,
        MINIMIZED,
        LEFT,
        SPLIT,
        DETACHED,
        FLOATING;

    }
}

