/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.ImageUtils;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/adtui/ui/ImagePanel;", "Lcom/intellij/ui/components/JBPanel;", "highFidelityScaling", "", "(Z)V", "value", "active", "getActive", "()Z", "setActive", "getHighFidelityScaling", "Ljava/awt/Image;", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.android.adt.ui"})
public final class ImagePanel
extends JBPanel<ImagePanel> {
    @Nullable
    private Image image;
    private boolean active;
    private final boolean highFidelityScaling;

    @Nullable
    public final Image getImage() {
        return this.image;
    }

    public final void setImage(@Nullable Image value) {
        this.image = value;
        this.repaint();
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean value) {
        this.active = value;
        this.repaint();
    }

    protected void paintComponent(@NotNull Graphics g) {
        block5: {
            Object $this$apply;
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Insets insets = this.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
            g.setColor(this.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            Composite prevComposite = null;
            if (!this.active) {
                object = (Graphics2D)g;
                bl2 = false;
                bl = false;
                $this$apply = object;
                boolean bl3 = false;
                prevComposite = ((Graphics2D)$this$apply).getComposite();
                ((Graphics2D)$this$apply).setComposite(AlphaComposite.SrcOver.derive(0.3f));
            }
            Image image = this.image;
            if (image != null) {
                object = image;
                bl2 = false;
                bl = false;
                Object img = object;
                boolean bl4 = false;
                int imageWidth = ((Image)img).getWidth((ImageObserver)((Object)this));
                int imageHeight = ((Image)img).getHeight((ImageObserver)((Object)this));
                if (imageWidth > 0 && imageHeight > 0) {
                    double scale = RangesKt.coerceAtMost((double)(rect.getWidth() / (double)imageWidth), (double)(rect.getHeight() / (double)imageHeight));
                    int w = MathKt.roundToInt((double)((double)imageWidth * scale));
                    int h = MathKt.roundToInt((double)((double)imageHeight * scale));
                    int xOffset = rect.x + (rect.width - w) / 2;
                    int yOffset = rect.y + (rect.height - h) / 2;
                    if (this.highFidelityScaling) {
                        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)img);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(img)");
                        BufferedImage bufferedImage2 = bufferedImage;
                        double graphicsScale = JBUIScale.sysScale((Graphics2D)((Graphics2D)g));
                        double scaleX = graphicsScale * (double)w / (double)imageWidth;
                        double scaleY = graphicsScale * (double)h / (double)imageHeight;
                        BufferedImage bufferedImage3 = ImageUtils.scale(bufferedImage2, scaleX, scaleY);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"ImageUtils.scale(bufferedImage, scaleX, scaleY)");
                        BufferedImage scaledImage = bufferedImage3;
                        g.drawImage(scaledImage, xOffset, yOffset, w, h, null);
                    } else {
                        g.drawImage((Image)img, xOffset, yOffset, w, h, null);
                    }
                }
            }
            object = (Graphics2D)g;
            bl2 = false;
            bl = false;
            $this$apply = object;
            boolean bl5 = false;
            Composite composite = prevComposite;
            if (composite == null) break block5;
            Composite composite2 = composite;
            boolean bl6 = false;
            boolean bl7 = false;
            Composite it = composite2;
            boolean bl8 = false;
            ((Graphics2D)$this$apply).setComposite(it);
        }
    }

    public final boolean getHighFidelityScaling() {
        return this.highFidelityScaling;
    }

    public ImagePanel(boolean highFidelityScaling) {
        super(true);
        this.highFidelityScaling = highFidelityScaling;
        this.active = true;
    }

    public /* synthetic */ ImagePanel(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ImagePanel() {
        this(false, 1, null);
    }
}

