/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HideablePanel
extends JPanel {
    private static final Border HIDEABLE_PANEL_BORDER = new JBEmptyBorder(0, 10, 0, 15);
    private static final Border HIDEABLE_CONTENT_BORDER = new JBEmptyBorder(0, 12, 0, 5);
    private static final int TITLE_RIGHT_PADDING = 3;
    private boolean myExpanded;
    private final JComponent myChild;
    private final JLabel myLabel;
    private final EventListenerList myStateChangeListeners;
    private final JPanel myTitlePanel;

    public HideablePanel(@NotNull Builder builder) {
        if (builder == null) {
            HideablePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myChild = builder.myContent;
        this.myStateChangeListeners = new EventListenerList();
        this.myTitlePanel = new JPanel(new TabularLayout("Fit,*,Fit-"));
        this.myLabel = this.setupTitleBar(builder);
        this.setTitle(builder.myTitle);
        this.myChild.setBorder(builder.myContentBorder == null ? HIDEABLE_CONTENT_BORDER : builder.myContentBorder);
        this.setBorder(builder.myPanelBorder == null ? HIDEABLE_PANEL_BORDER : builder.myPanelBorder);
        this.add((Component)this.myChild, "Center");
        this.myExpanded = !builder.myInitiallyExpanded;
        this.setExpanded(builder.myInitiallyExpanded);
    }

    private JLabel setupTitleBar(@NotNull Builder builder) {
        JComponent clickableComponent;
        if (builder == null) {
            HideablePanel.$$$reportNull$$$0(1);
        }
        JLabel label2 = new JLabel();
        MouseAdapter toggleAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HideablePanel.this.setExpanded(!HideablePanel.this.isExpanded());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/adtui/ui/HideablePanel$1", "mouseReleased"));
            }
        };
        switch (builder.myClickableComponent) {
            case TITLE: {
                clickableComponent = label2;
                break;
            }
            default: {
                clickableComponent = this.myTitlePanel;
            }
        }
        clickableComponent.addMouseListener(toggleAdapter);
        clickableComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.myTitlePanel.add((Component)label2, new TabularLayout.Constraint(0, 0));
        if (builder.myShowSeparator) {
            JComponent separatorComponent = AdtUiUtils.createHorizontalSeparator();
            separatorComponent.setBorder((Border)new JBEmptyBorder(0, 10, 0, builder.myTitleRightPadding));
            this.myTitlePanel.add((Component)separatorComponent, new TabularLayout.Constraint(0, 1));
        }
        if (builder.myNorthEastComponent != null) {
            this.myTitlePanel.add((Component)builder.myNorthEastComponent, new TabularLayout.Constraint(0, 2));
        }
        this.add((Component)this.myTitlePanel, "North");
        if (builder.myTitleLeftPadding != null) {
            label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)builder.myTitleLeftPadding, (int)0, (int)0));
        }
        if (builder.myIconTextGap != null) {
            label2.setIconTextGap(builder.myIconTextGap);
        }
        return label2;
    }

    public void setTitle(String title) {
        this.myLabel.setText(String.format("<html><nobr>%s</nobr></html>", title));
    }

    public void setExpanded(boolean expanded) {
        if (this.myExpanded != expanded) {
            ActionListener[] listeners;
            this.myExpanded = expanded;
            this.myChild.setVisible(expanded);
            if (expanded) {
                this.myLabel.setIcon(AllIcons.General.ArrowDown);
            } else {
                this.myLabel.setIcon(AllIcons.General.ArrowRight);
            }
            if (this.getParent() != null) {
                this.getParent().revalidate();
            }
            if ((listeners = (ActionListener[])this.myStateChangeListeners.getListeners(ActionListener.class)) != null) {
                for (ActionListener listener : listeners) {
                    listener.actionPerformed(null);
                }
            }
        }
    }

    public void addStateChangedListener(@NotNull ActionListener expandedListener) {
        if (expandedListener == null) {
            HideablePanel.$$$reportNull$$$0(2);
        }
        this.myStateChangeListeners.add(ActionListener.class, expandedListener);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myTitlePanel != null) {
            this.myTitlePanel.setBackground(bg);
        }
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedListener";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/ui/HideablePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupTitleBar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStateChangedListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Builder {
        @NotNull
        String myTitle;
        @NotNull
        JComponent myContent;
        @NotNull
        ClickableComponent myClickableComponent;
        @Nullable
        JComponent myNorthEastComponent;
        @Nullable
        Consumer<Boolean> myOnStateChangedConsumer;
        @Nullable
        Border myContentBorder;
        @Nullable
        Border myPanelBorder;
        boolean myShowSeparator;
        boolean myInitiallyExpanded;
        int myTitleRightPadding;
        @Nullable
        Integer myTitleLeftPadding;
        @Nullable
        Integer myIconTextGap;

        public Builder(@NotNull String title, @NotNull JComponent content) {
            if (title == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (content == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myClickableComponent = ClickableComponent.TITLE_BAR;
            this.myShowSeparator = true;
            this.myInitiallyExpanded = true;
            this.myTitleRightPadding = 3;
            this.myTitle = title;
            this.myContent = content;
        }

        @NotNull
        public Builder setNorthEastComponent(@Nullable JComponent northEastComponent) {
            this.myNorthEastComponent = northEastComponent;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setInitiallyExpanded(boolean initiallyExpanded) {
            this.myInitiallyExpanded = initiallyExpanded;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setShowSeparator(boolean show) {
            this.myShowSeparator = show;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setContentBorder(@NotNull Border border) {
            if (border == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myContentBorder = border;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setPanelBorder(@NotNull Border border) {
            if (border == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myPanelBorder = border;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setTitleLeftPadding(int leftPadding) {
            this.myTitleLeftPadding = leftPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder setTitleRightPadding(int rightPadding) {
            this.myTitleRightPadding = rightPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setIconTextGap(int gap) {
            this.myIconTextGap = gap;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder setClickableComponent(@NotNull ClickableComponent clickableComponent) {
            if (clickableComponent == null) {
                Builder.$$$reportNull$$$0(12);
            }
            this.myClickableComponent = clickableComponent;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public HideablePanel build() {
            return new HideablePanel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/ui/HideablePanel$Builder";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "border";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickableComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/ui/HideablePanel$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNorthEastComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInitiallyExpanded";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setShowSeparator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setContentBorder";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPanelBorder";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTitleLeftPadding";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTitleRightPadding";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIconTextGap";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClickableComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setContentBorder";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setPanelBorder";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setClickableComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ClickableComponent {
        TITLE,
        TITLE_BAR;

    }
}

