/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.android.tools.adtui.treegrid.TreeGrid;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ui.SpeedSearchBase;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGridSpeedSearch<T>
extends SpeedSearchBase<TreeGrid<T>> {
    private final Function<T, String> myConverter;
    private boolean myWasPopupRecentlyActive;

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid) {
        if (grid == null) {
            TreeGridSpeedSearch.$$$reportNull$$$0(0);
        }
        this(grid, null);
    }

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid, @Nullable Function<T, String> converter) {
        if (grid == null) {
            TreeGridSpeedSearch.$$$reportNull$$$0(1);
        }
        super(grid);
        this.myConverter = converter;
        this.addChangeListener(event -> this.popupChange());
    }

    protected int getSelectedIndex() {
        int offset = 0;
        List lists = ((TreeGrid)this.myComponent).getLists();
        for (JList list : lists) {
            if (list.getSelectedIndex() > -1) {
                return offset + list.getSelectedIndex();
            }
            offset += list.getModel().getSize();
        }
        return -1;
    }

    @NotNull
    protected ListIterator<Object> getElementIterator(int startingViewIndex) {
        AbstractTreeStructure model2 = ((TreeGrid)this.myComponent).getModel();
        List list = model2 == null ? Collections.emptyList() : Arrays.stream(model2.getChildElements(model2.getRootElement())).flatMap(section -> Arrays.stream(model2.getChildElements(section))).collect(Collectors.toUnmodifiableList());
        ListIterator<Object> listIterator = list.listIterator(startingViewIndex);
        if (listIterator == null) {
            TreeGridSpeedSearch.$$$reportNull$$$0(2);
        }
        return listIterator;
    }

    protected int getElementCount() {
        AbstractTreeStructure model2 = ((TreeGrid)this.myComponent).getModel();
        return model2 == null ? 0 : (int)Arrays.stream(model2.getChildElements(model2.getRootElement())).flatMap(section -> Arrays.stream(model2.getChildElements(section))).count();
    }

    @Nullable
    protected String getElementText(@NotNull Object element) {
        if (element == null) {
            TreeGridSpeedSearch.$$$reportNull$$$0(3);
        }
        if (this.myConverter != null) {
            return this.myConverter.apply(element);
        }
        return element.toString();
    }

    protected void selectElement(@NotNull Object element, String selectedText) {
        if (element == null) {
            TreeGridSpeedSearch.$$$reportNull$$$0(4);
        }
        ((TreeGrid)this.myComponent).setSelectedElement(element);
    }

    private void popupChange() {
        boolean isPopupCurrentlyActive = this.isPopupActive();
        if (!isPopupCurrentlyActive && this.myWasPopupRecentlyActive && this.focusInTreeGrid()) {
            ((TreeGrid)this.myComponent).requestFocus();
        }
        this.myWasPopupRecentlyActive = isPopupCurrentlyActive;
    }

    private boolean focusInTreeGrid() {
        Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focus != null && SwingUtilities.isDescendingFrom(focus, this.myComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/treegrid/TreeGridSpeedSearch";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGridSpeedSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

