/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.trackgroup;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.trackgroup.SelectableTrackModel;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.trackgroup.TrackGroup;
import com.android.tools.adtui.trackgroup.TrackGroupMover;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackGroupListPanel
implements TrackGroupMover {
    private final JPanel myPanel;
    private final JPanel myTooltipPanel;
    private final List<TrackGroup> myTrackGroups;
    private final TrackRendererFactory myTrackRendererFactory;
    private final ViewBinder<JComponent, TooltipModel, TooltipView> myTooltipBinder;
    @Nullable
    private TooltipModel myActiveTooltip;
    @Nullable
    private TooltipView myActiveTooltipView;
    @Nullable
    private RangeTooltipComponent myRangeTooltipComponent;

    public TrackGroupListPanel(@NotNull TrackRendererFactory trackRendererFactory) {
        if (trackRendererFactory == null) {
            TrackGroupListPanel.$$$reportNull$$$0(0);
        }
        this.myTooltipBinder = new ViewBinder();
        this.myPanel = new JPanel(new TabularLayout("150px,*", "Fit"));
        this.myTooltipPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.myTooltipPanel.setBackground((Color)StudioColorsKt.getCanvasTooltipBackground());
        this.myTrackGroups = new ArrayList<TrackGroup>();
        this.myTrackRendererFactory = trackRendererFactory;
    }

    public void loadTrackGroups(@NotNull List<TrackGroupModel> trackGroupModels) {
        if (trackGroupModels == null) {
            TrackGroupListPanel.$$$reportNull$$$0(1);
        }
        this.loadTrackGroups(trackGroupModels, false);
    }

    public void loadTrackGroups(@NotNull List<TrackGroupModel> trackGroupModels, boolean enableTrackGroupMoving) {
        if (trackGroupModels == null) {
            TrackGroupListPanel.$$$reportNull$$$0(2);
        }
        this.myTrackGroups.clear();
        trackGroupModels.forEach(model2 -> this.myTrackGroups.add(new TrackGroup((TrackGroupModel)model2, this.myTrackRendererFactory).setMover(enableTrackGroupMoving ? this : null)));
        this.registerTooltipListeners();
        this.initTrackGroups();
    }

    @Override
    public void moveTrackGroupUp(@NotNull TrackGroup trackGroup) {
        if (trackGroup == null) {
            TrackGroupListPanel.$$$reportNull$$$0(3);
        }
        int index = this.myTrackGroups.indexOf(trackGroup);
        assert (index >= 0);
        if (index > 0) {
            this.myTrackGroups.remove(index);
            this.myTrackGroups.add(index - 1, trackGroup);
            this.initTrackGroups();
        }
    }

    @Override
    public void moveTrackGroupDown(@NotNull TrackGroup trackGroup) {
        if (trackGroup == null) {
            TrackGroupListPanel.$$$reportNull$$$0(4);
        }
        int index = this.myTrackGroups.indexOf(trackGroup);
        assert (index >= 0);
        if (index < this.myTrackGroups.size() - 1) {
            this.myTrackGroups.remove(index);
            this.myTrackGroups.add(index + 1, trackGroup);
            this.initTrackGroups();
        }
    }

    public <T extends SelectableTrackModel> void registerMultiSelectionModel(@NotNull MultiSelectionModel<T> multiSelectionModel) {
        if (multiSelectionModel == null) {
            TrackGroupListPanel.$$$reportNull$$$0(5);
        }
        this.myTrackGroups.forEach(trackGroup -> {
            if (trackGroup.getModel().isTrackSelectable()) {
                trackGroup.getTrackList().addListSelectionListener(new TrackGroupSelectionListener((TrackGroup)trackGroup, multiSelectionModel));
            }
        });
    }

    public void setRangeTooltipComponent(@Nullable RangeTooltipComponent rangeTooltipComponent) {
        this.myRangeTooltipComponent = rangeTooltipComponent;
        this.registerTooltipListeners();
    }

    public void setEnabled(boolean enabled) {
        this.myTrackGroups.forEach(trackGroup -> trackGroup.setEventHandlersEnabled(enabled));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TrackGroupListPanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public JPanel getTooltipPanel() {
        JPanel jPanel = this.myTooltipPanel;
        if (jPanel == null) {
            TrackGroupListPanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    public ViewBinder<JComponent, TooltipModel, TooltipView> getTooltipBinder() {
        ViewBinder<JComponent, TooltipModel, TooltipView> viewBinder = this.myTooltipBinder;
        if (viewBinder == null) {
            TrackGroupListPanel.$$$reportNull$$$0(8);
        }
        return viewBinder;
    }

    @VisibleForTesting
    @NotNull
    public List<TrackGroup> getTrackGroups() {
        List<TrackGroup> list = this.myTrackGroups;
        if (list == null) {
            TrackGroupListPanel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @VisibleForTesting
    @Nullable
    public TooltipModel getActiveTooltip() {
        return this.myActiveTooltip;
    }

    private void initTrackGroups() {
        this.myPanel.removeAll();
        if (this.myRangeTooltipComponent != null) {
            this.myPanel.add((Component)this.myRangeTooltipComponent, new TabularLayout.Constraint(0, 1, this.myTrackGroups.size(), 1));
        }
        for (int i = 0; i < this.myTrackGroups.size(); ++i) {
            JComponent trackGroupComponent = this.myTrackGroups.get(i).getComponent();
            this.myPanel.add(trackGroupComponent, new TabularLayout.Constraint(i, 0, 1, 2), i);
            DelegateMouseEventHandler.delegateTo(this.myPanel).installListenerOn(trackGroupComponent).installMotionListenerOn(trackGroupComponent).installMouseWheelListenerOn(trackGroupComponent);
        }
        this.myPanel.revalidate();
    }

    private void setTooltip(TooltipModel tooltip) {
        if (tooltip != this.myActiveTooltip) {
            this.myActiveTooltip = tooltip;
            this.tooltipChanged();
        }
    }

    private void tooltipChanged() {
        if (this.myActiveTooltipView != null) {
            this.myActiveTooltipView.dispose();
            this.myActiveTooltipView = null;
        }
        this.myTooltipPanel.removeAll();
        this.myTooltipPanel.setVisible(false);
        if (this.myActiveTooltip != null) {
            this.myActiveTooltipView = this.myTooltipBinder.build(this.getComponent(), this.myActiveTooltip);
            this.myTooltipPanel.add(this.myActiveTooltipView.createComponent());
            this.myTooltipPanel.setVisible(true);
        }
        this.myTooltipPanel.invalidate();
        this.myTooltipPanel.repaint();
    }

    private void registerTooltipListeners() {
        for (TrackGroup trackGroup : this.myTrackGroups) {
            TooltipMouseAdapter adapter = new TooltipMouseAdapter(trackGroup);
            trackGroup.getOverlay().addMouseListener(adapter);
            trackGroup.getOverlay().addMouseMotionListener(adapter);
            if (this.myRangeTooltipComponent == null) continue;
            this.myRangeTooltipComponent.registerListenersOn(trackGroup.getOverlay());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackRendererFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackGroupModels";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiSelectionModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/trackgroup/TrackGroupListPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/trackgroup/TrackGroupListPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipBinder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTrackGroups";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveTrackGroupUp";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveTrackGroupDown";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerMultiSelectionModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TooltipMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final TrackGroup myTrackGroup;

        private TooltipMouseAdapter(TrackGroup trackGroup) {
            if (trackGroup == null) {
                TooltipMouseAdapter.$$$reportNull$$$0(0);
            }
            this.myTrackGroup = trackGroup;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.updateTooltipOnMove(event);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.updateTooltipOnMove(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            TrackGroupListPanel.this.setTooltip(null);
        }

        private void updateTooltipOnMove(MouseEvent event) {
            int trackIndex = this.myTrackGroup.getTrackList().locationToIndex(event.getPoint());
            TrackGroupListPanel.this.setTooltip(trackIndex == -1 ? null : this.myTrackGroup.getTrackModelAt(trackIndex).getActiveTooltipModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackGroup", "com/android/tools/adtui/trackgroup/TrackGroupListPanel$TooltipMouseAdapter", "<init>"));
        }
    }

    private static class TrackGroupSelectionListener<T extends SelectableTrackModel>
    implements ListSelectionListener {
        private final TrackGroup myTrackGroup;
        private final MultiSelectionModel<T> myMultiSelectionModel;
        private boolean handleListSelectionEvent;

        TrackGroupSelectionListener(@NotNull TrackGroup trackGroup, @NotNull MultiSelectionModel<T> multiSelectionModel) {
            if (trackGroup == null) {
                TrackGroupSelectionListener.$$$reportNull$$$0(0);
            }
            if (multiSelectionModel == null) {
                TrackGroupSelectionListener.$$$reportNull$$$0(1);
            }
            this.handleListSelectionEvent = true;
            this.myTrackGroup = trackGroup;
            this.myMultiSelectionModel = multiSelectionModel;
            multiSelectionModel.addDependency(trackGroup).onChange(MultiSelectionModel.Aspect.CHANGE_SELECTION, () -> {
                this.handleListSelectionEvent = false;
                if (multiSelectionModel.isEmpty()) {
                    trackGroup.getTrackList().clearSelection();
                } else if (!trackGroup.isEmpty()) {
                    SelectableTrackModel selection = (SelectableTrackModel)multiSelectionModel.getSelection().get(0);
                    SelectableTrackModel listModel = (SelectableTrackModel)trackGroup.getTrackModelAt(0).getDataModel();
                    if (!listModel.isCompatibleWith(selection)) {
                        trackGroup.getTrackList().clearSelection();
                    }
                }
                this.handleListSelectionEvent = true;
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.handleListSelectionEvent) {
                HashSet<SelectableTrackModel> selection = new HashSet<SelectableTrackModel>();
                for (int selectedIndex : this.myTrackGroup.getTrackList().getSelectedIndices()) {
                    selection.add((SelectableTrackModel)this.myTrackGroup.getTrackModelAt(selectedIndex).getDataModel());
                }
                this.myMultiSelectionModel.setSelection(selection);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trackGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "multiSelectionModel";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/trackgroup/TrackGroupListPanel$TrackGroupSelectionListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

