/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.adtui.stdui.Lookup;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001aH\u0014J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0088\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/adtui/stdui/CommonTextField;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/intellij/ui/components/JBTextField;", "editorModel", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;)V", "_lookup", "Lcom/android/tools/adtui/stdui/Lookup;", "documentChangeFromSetText", "", "getEditorModel", "()Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "lookup", "getLookup", "()Lcom/android/tools/adtui/stdui/Lookup;", "updatingFromModel", "backTab", "", "enterInLookup", "escapeInLookup", "getComponentWithErrorBorder", "Ljavax/swing/JComponent;", "setFromModel", "setText", "text", "", "showLookupCompletions", "forText", "tab", "updateFromModel", "updateOutline", "intellij.android.adt.ui"})
public class CommonTextField<M extends CommonTextFieldModel>
extends JBTextField {
    private Lookup<? extends M> _lookup;
    private boolean updatingFromModel;
    private boolean documentChangeFromSetText;
    @NotNull
    private final M editorModel;

    @Nullable
    public final Lookup<M> getLookup() {
        return this._lookup;
    }

    protected void showLookupCompletions(@NotNull String forText) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
            Lookup<M> lookup = this.getLookup();
            if (lookup == null) break block0;
            lookup.showLookup(forText);
        }
    }

    protected void updateFromModel() {
        this.setFromModel();
    }

    public final boolean enterInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.enter() : false;
    }

    public final boolean escapeInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.escape() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setFromModel() {
        this.updatingFromModel = true;
        try {
            this.setText(this.editorModel.getValue());
            this.setEnabled(this.editorModel.getEnabled());
            this.setEditable(this.editorModel.getEditable());
            StatusText statusText = this.getEmptyText();
            Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"emptyText");
            statusText.setText(this.editorModel.getPlaceHolderValue());
            this.updateOutline();
        }
        finally {
            this.updatingFromModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@Nullable String text) {
        this.documentChangeFromSetText = true;
        try {
            if (!StringsKt.equals$default((String)text, (String)super.getText(), (boolean)false, (int)2, null)) {
                super.setText(text);
            }
            UIUtil.resetUndoRedoActions((JTextComponent)((JTextComponent)((Object)this)));
        }
        finally {
            this.documentChangeFromSetText = false;
        }
    }

    private final void tab() {
        this.enterInLookup();
        this.transferFocus();
    }

    private final void backTab() {
        this.enterInLookup();
        this.transferFocusBackward();
    }

    private final void updateOutline() {
        JComponent jComponent = this.getComponentWithErrorBorder();
        if (jComponent == null) {
            return;
        }
        JComponent component = jComponent;
        Object current = component.getClientProperty("JComponent.outline");
        Pair pair = (Pair)this.editorModel.getEditingSupport().getValidation().invoke((Object)this.editorModel.getText());
        EditingErrorCategory code = (EditingErrorCategory)((Object)pair.component1());
        String newOutline = code.getOutline();
        if (Intrinsics.areEqual((Object)current, (Object)newOutline) ^ true) {
            component.putClientProperty("JComponent.outline", newOutline);
            component.repaint();
        }
    }

    private final JComponent getComponentWithErrorBorder() {
        if (this.getBorder() instanceof ErrorBorderCapable) {
            return (JComponent)((Object)this);
        }
        Container container = this.getParent();
        if (!(container instanceof JComponent)) {
            container = null;
        }
        JComponent jComponent = (JComponent)container;
        if (jComponent == null) {
            return null;
        }
        JComponent parent = jComponent;
        if (parent.getBorder() instanceof ErrorBorderCapable) {
            return parent;
        }
        return null;
    }

    @NotNull
    public final M getEditorModel() {
        return this.editorModel;
    }

    public CommonTextField(@NotNull M editorModel) {
        Intrinsics.checkNotNullParameter(editorModel, (String)"editorModel");
        this.editorModel = editorModel;
        if (Intrinsics.areEqual(this.editorModel.getEditingSupport().getCompletion(), EditingSupportKt.EDITOR_NO_COMPLETIONS) ^ true) {
            final Lookup myLookup = new Lookup(this, null, 2, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.enterInLookup();
                }
            }, KeyStrokes.INSTANCE.getENTER(), "enter", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.escapeInLookup();
                }
            }, KeyStrokes.INSTANCE.getESCAPE(), "escape", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.tab();
                }
            }, KeyStrokes.INSTANCE.getTAB(), "tab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.backTab();
                }
            }, KeyStrokes.INSTANCE.getBACKTAB(), "backTab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    String string = this.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    this.showLookupCompletions(string);
                }
            }, KeyStrokes.INSTANCE.getCTRL_SPACE(), "showCompletions", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectNext();
                }
            }, KeyStrokes.INSTANCE.getDOWN(), "selectNext", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectPrevious();
                }
            }, KeyStrokes.INSTANCE.getUP(), "selectPrevious", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectNextPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_DOWN(), "selectNextPage", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectPreviousPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_UP(), "selectPreviousPage", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectFirst();
                }
            }, KeyStrokes.INSTANCE.getCMD_HOME(), "selectFirst", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectLast();
                }
            }, KeyStrokes.INSTANCE.getCMD_END(), "selectLast", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            this.setFocusTraversalKeysEnabled(false);
            super.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(@NotNull FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    myLookup.close();
                }
            });
            this._lookup = myLookup;
        }
        this.putClientProperty("StatusVisibleFunction", new BooleanFunction(){

            public final boolean fun(JTextComponent it) {
                String string = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                CharSequence charSequence = string;
                boolean bl = false;
                return charSequence.length() == 0;
            }
        });
        this.setFocusable(true);
        this.setFromModel();
        this.editorModel.addListener(new ValueChangedListener(){

            @Override
            public final void valueChanged() {
                this.updateFromModel();
            }
        });
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                block1: {
                    block2: {
                        String newText;
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (updatingFromModel) break block1;
                            newText = this.getText();
                            Object m = this.getEditorModel();
                            String string = newText;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newText");
                            m.setText(string);
                            if (documentChangeFromSetText) break block2;
                            CharSequence charSequence = newText;
                            boolean bl = false;
                            if (charSequence.length() > 0) break block3;
                            Lookup lookup = this.getLookup();
                            if (lookup == null) break block2;
                            if (!lookup.isVisible()) break block2;
                        }
                        this.showLookupCompletions(newText);
                    }
                    this.updateOutline();
                }
            }
        });
    }

    public static final /* synthetic */ void access$setUpdatingFromModel$p(CommonTextField $this, boolean bl) {
        $this.updatingFromModel = bl;
    }

    public static final /* synthetic */ void access$setDocumentChangeFromSetText$p(CommonTextField $this, boolean bl) {
        $this.documentChangeFromSetText = bl;
    }
}

